/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.icons.FlipFlopIcon;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.AbstractFlipFlop;
import com.cburch.logisim.std.memory.AbstractFlipFlopHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;

public class JKFlipFlop
extends AbstractFlipFlop {
    public static final String _ID = "J-K Flip-Flop";

    public JKFlipFlop() {
        super(_ID, new FlipFlopIcon(2), Strings.S.getter("jkFlipFlopComponent"), 2, false, (HdlGeneratorFactory)new JKFFHDLGeneratorFactory());
    }

    @Override
    protected Value computeValue(Value[] inputs, Value curValue) {
        if (inputs[0] == Value.FALSE) {
            if (inputs[1] == Value.FALSE) {
                return curValue;
            }
            if (inputs[1] == Value.TRUE) {
                return Value.FALSE;
            }
        } else if (inputs[0] == Value.TRUE) {
            if (inputs[1] == Value.FALSE) {
                return Value.TRUE;
            }
            if (inputs[1] == Value.TRUE) {
                return curValue.not();
            }
        }
        return Value.UNKNOWN;
    }

    @Override
    protected String getInputName(int index) {
        return index == 0 ? "J" : "K";
    }

    private static class JKFFHDLGeneratorFactory
    extends AbstractFlipFlopHdlGeneratorFactory {
        public JKFFHDLGeneratorFactory() {
            super(2, StdAttr.EDGE_TRIGGER);
            this.myPorts.add("input", "j", 1, 0).add("input", "k", 1, 1);
        }

        @Override
        public LineBuffer getUpdateLogic() {
            LineBuffer contents = LineBuffer.getHdlBuffer();
            String preamble = LineBuffer.formatHdl("{{assign}}s_nextState{{=}}", new Object[0]);
            contents.add("{{1}}({{not}}(s_currentState){{and}}j){{or}}", preamble).add("{{1}}(s_currentState{{and}}{{not}}(k));", " ".repeat(preamble.length()));
            return contents;
        }
    }
}

