/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.Counter;
import com.cburch.logisim.std.memory.RegisterPoker;
import java.awt.Color;
import java.awt.Graphics;

public class CounterPoker
extends RegisterPoker {
    @Override
    public void paint(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        BitWidth dataWidth = painter.getAttributeValue(StdAttr.WIDTH);
        int width = dataWidth == null ? 8 : dataWidth.getWidth();
        int len = (width + 3) / 4;
        Graphics g = painter.getGraphics();
        g.setColor(Color.RED);
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            if (len > 4) {
                g.drawRect(bds.getX(), bds.getY() + 3, bds.getWidth(), 25);
            } else {
                int wid = 7 * len + 2;
                g.drawRect(bds.getX() + (bds.getWidth() - wid) / 2, bds.getY() + 4, wid, 15);
            }
        } else {
            int xcenter = Counter.getSymbolWidth(width) - 25;
            g.drawRect(bds.getX() + xcenter - len * 4, bds.getY() + 22, len * 8, 16);
        }
        g.setColor(Color.BLACK);
    }
}

