/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.std.io.LedArrayRowScanningHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class RgbArrayRowScanningHdlGeneratorFactory
extends LedArrayRowScanningHdlGeneratorFactory {
    public static final String HDL_IDENTIFIER = "RGBArrayRowScanning";
    static final LineBuffer.Pairs sharedPairs = new LineBuffer.Pairs().pair("insR", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs).pair("insG", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs).pair("insB", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs).pair("outsR", LedArrayGenericHdlGeneratorFactory.LedArrayColumnRedOutputs).pair("outsG", LedArrayGenericHdlGeneratorFactory.LedArrayColumnGreenOutputs).pair("outsB", LedArrayGenericHdlGeneratorFactory.LedArrayColumnBlueOutputs);

    public RgbArrayRowScanningHdlGeneratorFactory() {
        this.myWires.addWire("s_maxRedLedInputs", -7).addWire("s_maxBlueLedInputs", -7).addWire("s_maxGreenLedInputs", -7);
        this.myPorts.removePorts();
        this.myPorts.add("input", "fpgaGlobalClock", 1, 0).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, -1, 1).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, -1, 2).add("input", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, -1, 3).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress, -4, 4).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayColumnRedOutputs, -3, 5).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayColumnGreenOutputs, -3, 6).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayColumnBlueOutputs, -3, 7);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRowAddress, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayColumnRedOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayColumnRedOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayColumnGreenOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayColumnGreenOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayColumnBlueOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayColumnBlueOutputs, id));
        ports.put("fpgaGlobalClock", "fpgaGlobalClock");
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayRedInputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayGreenInputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayBlueInputs, id));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("activeLow", "activeLow").pair("nrOfLeds", "nrOfLeds").pair("nrOfColumns", "nrOfColumns");
        contents.add(RgbArrayRowScanningHdlGeneratorFactory.getRowCounterCode());
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("makeVirtualInputs : {{process}} ( internalRedLeds, internalGreenLeds, internalBlueLeds ) {{is}}\n{{begin}}\n   s_maxRedLedInputs <= ({{others}} => '0');\n   s_maxGreenLedInputs <= ({{others}} => '0');\n   s_maxBlueLedInputs <= ({{others}} => '0');\n   {{if}} ({{activeLow}} = 1) {{then}}\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{not}} {{insR}};\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{not}} {{insG}};\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{not}} {{insB}};\n   {{else}}\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{insR}};\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{insG}};\n      s_maxRedLedInputs({{nrOfLeds}}-1 {{downto}} 0) <= {{insB}};\n   {{end}} {{if}};\n{{end}} {{process}} makeVirtualInputs;\n\ngenOutputs : {{for}} n {{in}} {{nrOfColumns}}-1 {{downto}} 0 {{generate}}\n   {{outsR}}(n) <= s_maxRedLedInputs({{nrOfColumns}} * to_integer(unsigned(s_rowCounterReg)) + n);\n   {{outsG}}(n) <= s_maxRedLedInputs({{nrOfColumns}} * to_integer(unsigned(s_rowCounterReg)) + n);\n   {{outsB}}(n) <= s_maxRedLedInputs({{nrOfColumns}} * to_integer(unsigned(s_rowCounterReg)) + n);\n{{end}} {{generate}} genOutputs;\n").empty();
        } else {
            contents.add("genvar i;\ngenerate\n   for (i = 0; i < {{nrOfColumns}}; i = i + 1)\n   begin:outputs\n      assign {{outsR}}[i] = (activeLow == 1)\n         ? ~{{insR}}[{{nrOfColumns}} * s_rowCounterReg + i]\n         :  {{insR}}[{{nrOfColumns}} * s_rowCounterReg + i];\n      assign {{outsG}}[i] = (activeLow == 1)\n         ? ~{{insG}}[{{nrOfColumns}} * s_rowCounterReg + i]\n         :  {{insG}}[{{nrOfColumns}} * s_rowCounterReg + i];\n      assign {{outsB}}[i] = (activeLow == 1)\n         ? ~{{insB}}[{{nrOfColumns}} * s_rowCounterReg + i]\n         :  {{insB}}[{{nrOfColumns}} * s_rowCounterReg + i];\n   end\nendgenerate\" +\n").empty();
        }
        return contents;
    }
}

