/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.std.io.PortIo;
import com.cburch.logisim.util.LineBuffer;

public class PortHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        AttributeOption portType = componentInfo.getComponent().getAttributeSet().getValue(PortIo.ATTR_DIR);
        int nrOfPins = componentInfo.getComponent().getAttributeSet().getValue(PortIo.ATTR_SIZE).getWidth();
        int startIndex = componentInfo.getLocalBubbleInputStartId();
        int endIndex = startIndex + nrOfPins - 1;
        if (portType == PortIo.INPUT) {
            if (nrOfPins == 1) {
                contents.add("{{assign}} {{1}}{{=}}{{2}}{{<}}{{3}}{{>}};", Hdl.getNetName(componentInfo, 0, true, nets), "logisimInputBubbles", endIndex);
            } else {
                contents.add("{{assign}} {{1}}{{=}}{{2}}{{<}}{{3}}{{4}}{{5}}{{>}};", Hdl.getBusName(componentInfo, 0, nets), "logisimInputBubbles", endIndex, Hdl.vectorLoopId(), startIndex);
            }
        } else if (portType == PortIo.OUTPUT) {
            if (nrOfPins == 1) {
                contents.add("{{assign}} {{1}}{{<}}{{2}}{{>}}{{=}}{{3}};", "logisimOutputBubbles", endIndex, Hdl.getNetName(componentInfo, 0, true, nets));
            } else {
                contents.add("{{assign}} {{1}}{{<}}{{2}}{{3}}{{4}}{{>}}{{=}}{{5}};", "logisimOutputBubbles", endIndex, Hdl.vectorLoopId(), startIndex, Hdl.getBusName(componentInfo, 0, nets));
            }
        } else {
            if (nrOfPins == 1) {
                contents.add("{{assign}} {{1}}{{=}}{{2}}{{<}}{{3}}{{>}};", Hdl.getNetName(componentInfo, 2, true, nets), "logisimInOutBubbles", endIndex);
            } else {
                contents.add("{{assign}} {{1}}{{=}}{{2}}{{<}}{{3}}{{4}}{{5}}{{>}};", Hdl.getBusName(componentInfo, 2, nets), "logisimInOutBubbles", endIndex, Hdl.vectorLoopId(), startIndex);
            }
            if (portType == PortIo.INOUTSE || nrOfPins == 1) {
                if (Hdl.isVhdl()) {
                    if (nrOfPins == 1) {
                        contents.addVhdlKeywords().add("{{1}}({{2}}) <= {{3}} {{when}} {{4}} = '1' {{else}} ({{others}} => 'Z');", "logisimInOutBubbles", startIndex, Hdl.getNetName(componentInfo, 1, true, nets), Hdl.getNetName(componentInfo, 0, true, nets));
                    } else {
                        contents.addVhdlKeywords().add("{{1}}({{2}} {{downto}} {{3}}) <= {{4}} {{when}} {{5}} = '1' {{else}} ({{others}} => 'Z');", "logisimInOutBubbles", endIndex, startIndex, Hdl.getBusName(componentInfo, 1, nets), Hdl.getNetName(componentInfo, 0, true, nets));
                    }
                } else if (nrOfPins == 1) {
                    contents.add("assign {{1}}[{{2}}] = ({{3}}) ? {{4}} : {{5}}'bZ;", "logisimInOutBubbles", startIndex, Hdl.getNetName(componentInfo, 0, true, nets), Hdl.getNetName(componentInfo, 1, true, nets), nrOfPins);
                } else {
                    contents.add("assign {{1}}[{{2}}:{{3}}] = ({{4}}) ? {{5}} : {{6}}'bZ;", "logisimInOutBubbles", endIndex, startIndex, Hdl.getNetName(componentInfo, 0, true, nets), Hdl.getBusName(componentInfo, 1, nets), nrOfPins);
                }
            } else {
                for (int busBitIndex = 0; busBitIndex < nrOfPins; ++busBitIndex) {
                    if (Hdl.isVhdl()) {
                        contents.addVhdlKeywords().add("{{1}}({{2}}) <= {{3}} {{when}} {{4}} = '1' {{else}} 'Z';", "logisimInOutBubbles", startIndex + busBitIndex, Hdl.getBusEntryName(componentInfo, 1, true, busBitIndex, nets), Hdl.getBusEntryName(componentInfo, 0, true, busBitIndex, nets));
                        continue;
                    }
                    contents.add("assign {{1}}[{{2}}] = ({{3}}) ? {{4}} : 1'bZ;", "logisimInOutBubbles", startIndex + busBitIndex, Hdl.getBusEntryName(componentInfo, 0, true, busBitIndex, nets), Hdl.getBusEntryName(componentInfo, 1, true, busBitIndex, nets));
                }
            }
        }
        return contents;
    }
}

