/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.AbstractGateHdlGenerator;
import com.cburch.logisim.std.gates.GateFunctions;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics2D;

class EvenParityGate
extends AbstractGate {
    public static final EvenParityGate FACTORY = new EvenParityGate();
    private static final String LABEL = "2k";

    private EvenParityGate() {
        super("Even Parity", Strings.S.getter("evenParityComponent"), new XNorGateHdlGeneratorFactory());
        this.setRectangularLabel(LABEL);
    }

    @Override
    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        Expression ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = Expressions.xor(ret, inputs[i]);
        }
        return Expressions.not(ret);
    }

    @Override
    protected Value computeOutput(Value[] inputs, int numInputs, InstanceState state) {
        return GateFunctions.computeOddParity(inputs, numInputs).not();
    }

    @Override
    protected Value getIdentity() {
        return Value.FALSE;
    }

    @Override
    protected void paintDinShape(InstancePainter painter, int width, int height, int inputs) {
        this.paintRectangular(painter, width, height);
    }

    @Override
    public void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize) {
        AbstractGate.paintIconIEC(g, LABEL, false, false);
    }

    @Override
    protected void paintShape(InstancePainter painter, int width, int height) {
        this.paintRectangular(painter, width, height);
    }

    private static class XNorGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private XNorGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
            return LineBuffer.getBuffer().add(XNorGateHdlGeneratorFactory.getParity(true, nrOfInputs, bitwidth > 1));
        }
    }
}

