/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.circuit.ExpressionComputer;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NegateAttribute;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.tools.WireRepair;
import com.cburch.logisim.tools.WireRepairData;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.IntegerConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;

abstract class AbstractGate
extends InstanceFactory {
    private int bonusWidth = 0;
    private boolean negateOutput = false;
    private boolean isXor = false;
    private String rectLabel = "";
    private boolean paintInputLines;

    static Value pullOutput(Value value, Object outType) {
        Value[] v;
        block4: {
            block3: {
                if (outType == GateAttributes.OUTPUT_01) {
                    return value;
                }
                v = value.getAll();
                if (outType != GateAttributes.OUTPUT_0Z) break block3;
                for (int i = 0; i < v.length; ++i) {
                    if (v[i] != Value.TRUE) continue;
                    v[i] = Value.UNKNOWN;
                }
                break block4;
            }
            if (outType != GateAttributes.OUTPUT_Z1) break block4;
            for (int i = 0; i < v.length; ++i) {
                if (v[i] != Value.FALSE) continue;
                v[i] = Value.UNKNOWN;
            }
        }
        return Value.create(v);
    }

    protected AbstractGate(String name, StringGetter desc, HdlGeneratorFactory generator) {
        this(name, desc, false, generator);
    }

    protected AbstractGate(String name, StringGetter desc, boolean isXor, HdlGeneratorFactory generator) {
        super(name, desc, generator);
        this.isXor = isXor;
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(JoinedConfigurator.create(new IntegerConfigurator(GateAttributes.ATTR_INPUTS, 2, 64, 0), new BitWidthConfigurator(StdAttr.WIDTH)));
    }

    protected abstract Expression computeExpression(Expression[] var1, int var2);

    private void computeLabel(Instance instance) {
        int cy;
        int cx;
        GateAttributes attrs = (GateAttributes)instance.getAttributeSet();
        Direction facing = attrs.facing;
        Integer baseWidth = (Integer)attrs.size.getValue();
        int axis = baseWidth / 2 + (this.negateOutput ? 10 : 0);
        int perp = 0;
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            perp += 6;
        }
        Location loc = instance.getLocation();
        if (facing == Direction.NORTH) {
            cx = loc.getX() + perp;
            cy = loc.getY() + axis;
        } else if (facing == Direction.SOUTH) {
            cx = loc.getX() - perp;
            cy = loc.getY() - axis;
        } else if (facing == Direction.WEST) {
            cx = loc.getX() + axis;
            cy = loc.getY() - perp;
        } else {
            cx = loc.getX() - axis;
            cy = loc.getY() + perp;
        }
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, cx, cy, 0, 0);
    }

    protected abstract Value computeOutput(Value[] var1, int var2, InstanceState var3);

    void computePorts(Instance instance) {
        GateAttributes attrs = (GateAttributes)instance.getAttributeSet();
        int inputs = attrs.inputs;
        Port[] ports = new Port[inputs + 1];
        ports[0] = new Port(0, 0, "output", StdAttr.WIDTH);
        for (int i = 0; i < inputs; ++i) {
            Location offs = this.getInputOffset(attrs, i);
            ports[i + 1] = new Port(offs.getX(), offs.getY(), "input", StdAttr.WIDTH);
        }
        instance.setPorts(ports);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.computePorts(instance);
        this.computeLabel(instance);
    }

    @Override
    public boolean contains(Location loc, AttributeSet attrsBase) {
        GateAttributes attrs = (GateAttributes)attrsBase;
        if (super.contains(loc, attrs)) {
            if (attrs.negated == 0L) {
                return true;
            }
            Direction facing = attrs.facing;
            Bounds bds = this.getOffsetBounds(attrsBase);
            int delt = facing == Direction.NORTH ? loc.getY() - (bds.getY() + bds.getHeight()) : (facing == Direction.SOUTH ? loc.getY() - bds.getY() : (facing == Direction.WEST ? loc.getX() - (bds.getX() + bds.getHeight()) : loc.getX() - bds.getX()));
            if (Math.abs(delt) > 5) {
                return true;
            }
            int inputs = attrs.inputs;
            for (int i = 1; i <= inputs; ++i) {
                Location offs = this.getInputOffset(attrs, i);
                if (loc.manhattanDistanceTo(offs) > 5) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new GateAttributes(this.isXor);
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        return attr instanceof NegateAttribute ? Boolean.FALSE : super.getDefaultAttributeValue(attr, ver);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        Integer inputCount;
        GateAttributes myAttrs = (GateAttributes)attrs;
        StringBuilder completeName = new StringBuilder();
        completeName.append(CorrectLabel.getCorrectLabel(this.getName()).toUpperCase());
        BitWidth width = myAttrs.getValue(StdAttr.WIDTH);
        if (width.getWidth() > 1) {
            completeName.append("_BUS");
        }
        if ((inputCount = myAttrs.getValue(GateAttributes.ATTR_INPUTS)) > 2) {
            completeName.append("_").append(inputCount).append("_INPUTS");
        }
        if (myAttrs.containsAttribute(GateAttributes.ATTR_XOR) && myAttrs.getValue(GateAttributes.ATTR_XOR).equals(GateAttributes.XOR_ONE)) {
            completeName.append("_ONEHOT");
        }
        return completeName.toString();
    }

    protected abstract Value getIdentity();

    Location getInputOffset(GateAttributes attrs, int index) {
        int dy;
        int skipLowerEven;
        int skipDist;
        int skipStart;
        int inputs = attrs.inputs;
        Direction facing = attrs.facing;
        Integer size = (Integer)attrs.size.getValue();
        int axisLength = size + this.bonusWidth + (this.negateOutput ? 10 : 0);
        long negated = attrs.negated;
        if (inputs <= 3) {
            if (size < 40) {
                skipStart = -5;
                skipDist = 10;
                skipLowerEven = 10;
            } else if (size < 60 || inputs <= 2) {
                skipStart = -10;
                skipDist = 20;
                skipLowerEven = 20;
            } else {
                skipStart = -15;
                skipDist = 30;
                skipLowerEven = 30;
            }
        } else if (inputs == 4 && size >= 60) {
            skipStart = -5;
            skipDist = 20;
            skipLowerEven = 0;
        } else {
            skipStart = -5;
            skipDist = 10;
            skipLowerEven = 10;
        }
        if ((inputs & 1) == 1) {
            dy = skipStart * (inputs - 1) + skipDist * index;
        } else {
            dy = skipStart * inputs + skipDist * index;
            if (index >= inputs / 2) {
                dy += skipLowerEven;
            }
            if (inputs == 4 && size >= 60) {
                dy -= 10;
            }
        }
        int dx = axisLength;
        int negatedBit = (int)(negated >> index) & 1;
        if (negatedBit == 1) {
            dx += 10;
        }
        if (facing == Direction.NORTH) {
            return Location.create(dy, dx, true);
        }
        if (facing == Direction.SOUTH) {
            return Location.create(dy, -dx, true);
        }
        if (facing == Direction.WEST) {
            return Location.create(dx, dy, true);
        }
        return Location.create(-dx, dy, true);
    }

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == WireRepair.class) {
            return data -> this.shouldRepairWire(instance, data);
        }
        if (key == ExpressionComputer.class) {
            return expressionMap -> {
                GateAttributes attrs = (GateAttributes)instance.getAttributeSet();
                int inputCount = attrs.inputs;
                long negated = attrs.negated;
                int width = attrs.width.getWidth();
                for (int b = 0; b < width; ++b) {
                    Expression[] inputs = new Expression[inputCount];
                    int numInputs = 0;
                    for (int i = 1; i <= inputCount; ++i) {
                        Expression e = expressionMap.get(instance.getPortLocation(i), b);
                        if (e == null) continue;
                        int negatedBit = (int)(negated >> i - 1) & 1;
                        if (negatedBit == 1) {
                            e = Expressions.not(e);
                        }
                        inputs[numInputs] = e;
                        ++numInputs;
                    }
                    if (numInputs <= 0) continue;
                    Expression out = this.computeExpression(inputs, numInputs);
                    expressionMap.put(instance.getPortLocation(0), b, out);
                }
            };
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrsBase) {
        GateAttributes attrs = (GateAttributes)attrsBase;
        Direction facing = attrs.facing;
        Integer size = (Integer)attrs.size.getValue();
        int inputs = attrs.inputs;
        if (inputs % 2 == 0) {
            ++inputs;
        }
        long negated = attrs.negated;
        int width = size + this.bonusWidth + (this.negateOutput ? 10 : 0);
        if (negated != 0L) {
            width += 10;
        }
        int height = Math.max(10 * inputs, size);
        if (facing == Direction.SOUTH) {
            return Bounds.create(-height / 2, -width, height, width);
        }
        if (facing == Direction.NORTH) {
            return Bounds.create(-height / 2, 0, height, width);
        }
        if (facing == Direction.WEST) {
            return Bounds.create(0, -height / 2, width, height);
        }
        return Bounds.create(-width, -height / 2, width, height);
    }

    protected String getRectangularLabel(AttributeSet attrs) {
        return this.rectLabel;
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return attrs.containsAttribute(GateAttributes.ATTR_OUTPUT) ? attrs.getValue(GateAttributes.ATTR_OUTPUT) != GateAttributes.OUTPUT_01 : false;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == GateAttributes.ATTR_SIZE || attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.computePorts(instance);
            this.computeLabel(instance);
        } else if (attr == GateAttributes.ATTR_INPUTS || attr instanceof NegateAttribute) {
            instance.recomputeBounds();
            this.computePorts(instance);
        } else if (attr == GateAttributes.ATTR_XOR) {
            instance.fireInvalidated();
        }
    }

    private void paintBase(InstancePainter painter) {
        GateAttributes attrs = (GateAttributes)painter.getAttributeSet();
        Direction facing = attrs.facing;
        int inputs = attrs.inputs;
        long negated = attrs.negated;
        Object shape = painter.getGateShape();
        Location loc = painter.getLocation();
        Bounds bds = painter.getOffsetBounds();
        int width = bds.getWidth();
        int height = bds.getHeight();
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int t = width;
            width = height;
            height = t;
        }
        if (negated != 0L) {
            width -= 10;
        }
        Graphics g = painter.getGraphics();
        Color baseColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        if (shape == "shaped" && this.paintInputLines) {
            PainterShaped.paintInputLines(painter, this);
        } else if (negated != 0L) {
            for (int i = 0; i < inputs; ++i) {
                int negatedBit = (int)(negated >> i) & 1;
                if (negatedBit != 1) continue;
                Location in = this.getInputOffset(attrs, i);
                Location cen = in.translate(facing, 5);
                painter.drawDongle(loc.getX() + cen.getX(), loc.getY() + cen.getY());
            }
        }
        g.setColor(baseColor);
        g.translate(loc.getX(), loc.getY());
        double rotate = 0.0;
        if (facing != Direction.EAST && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            rotate = -facing.toRadians();
            g2.rotate(rotate);
        }
        if (shape == "rectangular") {
            this.paintRectangular(painter, width, height);
        } else if (this.negateOutput) {
            g.translate(-10, 0);
            this.paintShape(painter, width - 10, height);
            painter.drawDongle(5, 0);
            g.translate(10, 0);
        } else {
            this.paintShape(painter, width, height);
        }
        if (rotate != 0.0) {
            ((Graphics2D)g).rotate(-rotate);
        }
        g.translate(-loc.getX(), -loc.getY());
        painter.drawLabel();
    }

    protected abstract void paintDinShape(InstancePainter var1, int var2, int var3, int var4);

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paintBase(painter);
    }

    @Override
    public final void paintIcon(InstancePainter painter) {
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        GraphicsUtil.switchToWidth(g, AppPreferences.getScaled(1));
        int border = AppPreferences.getIconBorder();
        if (painter.getGateShape().equals("rectangular")) {
            AbstractGate.paintIconIEC(g, this.getRectangularLabel(painter.getAttributeSet()), this.negateOutput, false);
        } else {
            this.paintIconANSI(g, AppPreferences.getIconSize() - (border << 1), border, AppPreferences.getScaled(4));
        }
        g.dispose();
    }

    protected static void paintIconIEC(Graphics2D g, String label, boolean negateOutput, boolean singleInput) {
        GraphicsUtil.switchToWidth(g, AppPreferences.getScaled(1));
        int iconBorder = AppPreferences.getIconBorder();
        int iconSize = AppPreferences.getIconSize() - (iconBorder << 1);
        int negateDiameter = AppPreferences.getScaled(4);
        int yoffset = singleInput ? (int)((double)iconSize / 6.0) : 0;
        int ysize = singleInput ? iconSize - (yoffset << 1) : iconSize;
        AffineTransform af = g.getTransform();
        g.translate(iconBorder, iconBorder);
        g.drawRect(0, yoffset, iconSize - negateDiameter, ysize);
        Font iconFont = g.getFont().deriveFont((float)iconSize / 2.0f).deriveFont(1);
        g.setFont(iconFont);
        if (label.length() < 3) {
            TextLayout txt = new TextLayout(label, iconFont, g.getFontRenderContext());
            float xpos = ((float)iconSize - (float)negateDiameter) / 2.0f - (float)txt.getBounds().getCenterX();
            float ypos = (float)iconSize / 2.0f - (float)txt.getBounds().getCenterY();
            txt.draw(g, xpos, ypos);
        } else {
            TextLayout txt = new TextLayout(label.substring(0, 2), iconFont, g.getFontRenderContext());
            float xpos = ((float)iconSize - (float)negateDiameter) / 2.0f - (float)txt.getBounds().getCenterX();
            float ypos = (float)iconSize / 4.0f - (float)txt.getBounds().getCenterY();
            txt.draw(g, xpos, ypos);
            txt = new TextLayout(label.substring(2, label.length() < 5 ? label.length() : 4), iconFont, g.getFontRenderContext());
            xpos = ((float)iconSize - (float)negateDiameter) / 2.0f - (float)txt.getBounds().getCenterX();
            ypos = 3.0f * (float)iconSize / 4.0f - (float)txt.getBounds().getCenterY();
            txt.draw(g, xpos, ypos);
        }
        AbstractGate.paintIconPins(g, iconSize, iconBorder, negateDiameter, negateOutput, singleInput);
        g.setTransform(af);
    }

    protected static void paintIconPins(Graphics2D g, int iconSize, int iconBorder, int negateDiameter, boolean negateOutput, boolean singleInput) {
        if (negateOutput) {
            g.drawOval(iconSize - negateDiameter, iconSize - negateDiameter >> 1, negateDiameter, negateDiameter);
        }
        g.drawLine(iconSize - (negateOutput ? 0 : negateDiameter), iconSize >> 1, iconSize - (negateOutput ? 0 : negateDiameter) + iconBorder, iconSize >> 1);
        if (singleInput) {
            g.drawLine(-iconBorder, iconSize >> 1, 0, iconSize >> 1);
        } else {
            g.drawLine(-iconBorder, iconSize >> 2, 0, iconSize >> 2);
            g.drawLine(-iconBorder, 3 * iconSize >> 2, 0, 3 * iconSize >> 2);
        }
    }

    protected static void paintIconBufferAnsi(Graphics2D gfx, boolean negate, boolean controlled) {
        GraphicsUtil.switchToWidth(gfx, AppPreferences.getScaled(1));
        int borderSize = AppPreferences.getIconBorder();
        int iconSize = AppPreferences.getIconSize() - (borderSize << 1);
        int negateSize = AppPreferences.getScaled(4);
        AffineTransform af = gfx.getTransform();
        gfx.translate(borderSize, borderSize);
        int ystart = negateSize >> 1;
        int yend = iconSize - ystart;
        boolean xstart = false;
        int xend = iconSize - negateSize;
        int[] xpos = new int[]{0, xend, 0, 0};
        int[] ypos = new int[]{ystart, iconSize >> 1, yend, ystart};
        gfx.drawPolygon(xpos, ypos, 4);
        AbstractGate.paintIconPins(gfx, iconSize, borderSize, negateSize, negate, true);
        if (controlled) {
            gfx.drawLine(xend >> 1, (3 * (yend - ystart) >> 2) + ystart, xend >> 1, yend);
        }
        gfx.setTransform(af);
    }

    protected abstract void paintIconANSI(Graphics2D var1, int var2, int var3, int var4);

    @Override
    public void paintInstance(InstancePainter painter) {
        this.paintBase(painter);
        if (!painter.isPrintView() || painter.getGateShape() == "rectangular") {
            painter.drawPorts();
        }
    }

    protected void paintRectangular(InstancePainter painter, int width, int height) {
        int don = this.negateOutput ? 10 : 0;
        AttributeSet attrs = painter.getAttributeSet();
        painter.drawRectangle(-width, -height / 2, width - don, height, this.getRectangularLabel(attrs));
        if (this.negateOutput) {
            painter.drawDongle(-5, 0);
        }
    }

    protected abstract void paintShape(InstancePainter var1, int var2, int var3);

    @Override
    public void propagate(InstanceState state) {
        GateAttributes attrs = (GateAttributes)state.getAttributeSet();
        int inputCount = attrs.inputs;
        long negated = attrs.negated;
        AttributeSet opts = state.getProject().getOptions().getAttributeSet();
        boolean errorIfUndefined = opts.getValue(Options.ATTR_GATE_UNDEFINED).equals(Options.GATE_UNDEFINED_ERROR);
        Value[] inputs = new Value[inputCount];
        int numInputs = 0;
        boolean error = false;
        for (int i = 1; i <= inputCount; ++i) {
            if (state.isPortConnected(i)) {
                int negatedBit = (int)(negated >> i - 1) & 1;
                inputs[numInputs] = negatedBit == 1 ? state.getPortValue(i).not() : state.getPortValue(i);
                ++numInputs;
                continue;
            }
            if (!errorIfUndefined) continue;
            error = true;
        }
        Value out = numInputs == 0 || error ? Value.createError(attrs.width) : AbstractGate.pullOutput(this.computeOutput(inputs, numInputs, state), attrs.out);
        state.setPort(0, out, 1);
    }

    protected void setAdditionalWidth(int value) {
        this.bonusWidth = value;
    }

    protected void setNegateOutput(boolean value) {
        this.negateOutput = value;
    }

    protected void setPaintInputLines(boolean value) {
        this.paintInputLines = value;
    }

    protected void setRectangularLabel(String value) {
        this.rectLabel = value;
    }

    protected boolean shouldRepairWire(Instance instance, WireRepairData data) {
        return false;
    }
}

