/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2DataTransferInstructions
implements AssemblerExecutionInterface {
    private static final int INSTR_LDW = 0;
    private static final int INSTR_LDH = 1;
    private static final int INSTR_LDHU = 2;
    private static final int INSTR_LDB = 3;
    private static final int INSTR_LDBU = 4;
    private static final int INSTR_LDWIO = 5;
    private static final int INSTR_LDHIO = 6;
    private static final int INSTR_LDHUIO = 7;
    private static final int INSTR_LDBIO = 8;
    private static final int INSTR_LDBUIO = 9;
    private static final int INSTR_STW = 10;
    private static final int INSTR_STH = 11;
    private static final int INSTR_STB = 12;
    private static final int INSTR_STWIO = 13;
    private static final int INSTR_STHIO = 14;
    private static final int INSTR_STBIO = 15;
    private static final String[] AsmOpcodes = new String[]{"LDW", "LDH", "LDHU", "LDB", "LDBU", "LDWIO", "LDHIO", "LDHUIO", "LDBIO", "LDBUIO", "STW", "STH", "STB", "STWIO", "STHIO", "STBIO"};
    private static final Integer[] AsmOpcs = new Integer[]{23, 15, 11, 7, 3, 55, 47, 43, 39, 35, 21, 13, 5, 53, 45, 37};
    private final ArrayList<String> Opcodes = new ArrayList();
    private final ArrayList<Integer> OpcCodes = new ArrayList();
    private int instruction;
    private boolean valid;
    private int operation;
    private int destination;
    private int immediate;
    private int base;
    private String errorMessage;

    public Nios2DataTransferInstructions() {
        for (int i = 0; i < 16; ++i) {
            this.Opcodes.add(AsmOpcodes[i].toLowerCase());
            this.OpcCodes.add(AsmOpcs[i]);
        }
    }

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState cpuState = (Nios2State.ProcessorState)processorState;
        long address = SocSupport.convUnsignedInt(cpuState.getRegisterValue(this.base)) + (long)this.immediate;
        this.errorMessage = null;
        int toBeStored = cpuState.getRegisterValue(this.destination);
        int transType = -1;
        switch (this.operation) {
            case 12: 
            case 15: {
                toBeStored &= 0xFF;
                transType = 1;
            }
            case 11: 
            case 14: {
                toBeStored &= 0xFFFF;
                if (transType < 0) {
                    transType = 2;
                }
            }
            case 10: 
            case 13: {
                if (transType < 0) {
                    transType = 3;
                }
                SocBusTransaction trans = new SocBusTransaction(2, SocSupport.convUnsignedLong(address), toBeStored, transType, cpuState.getMasterComponent());
                cpuState.insertTransaction(trans, false, circuitState);
                return !this.transactionHasError(trans);
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                transType = 1;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                if (transType < 0) {
                    transType = 2;
                }
            }
            case 0: 
            case 5: {
                if (transType < 0) {
                    transType = 3;
                }
                SocBusTransaction trans = new SocBusTransaction(1, SocSupport.convUnsignedLong(address), 0, transType, cpuState.getMasterComponent());
                cpuState.insertTransaction(trans, false, circuitState);
                if (this.transactionHasError(trans)) {
                    return false;
                }
                int toBeLoaded = trans.getReadData();
                switch (this.operation) {
                    case 4: 
                    case 9: {
                        toBeLoaded &= 0xFF;
                        break;
                    }
                    case 3: 
                    case 8: {
                        toBeLoaded <<= 24;
                        toBeLoaded >>= 24;
                        break;
                    }
                    case 2: 
                    case 7: {
                        toBeLoaded &= 0xFFFF;
                        break;
                    }
                    case 1: 
                    case 6: {
                        toBeLoaded <<= 16;
                        toBeLoaded >>= 16;
                    }
                }
                cpuState.writeRegister(this.destination, toBeLoaded);
                return true;
            }
        }
        return false;
    }

    private boolean transactionHasError(SocBusTransaction trans) {
        if (trans.hasError()) {
            StringBuilder s = new StringBuilder();
            if (trans.isReadTransaction()) {
                s.append(Strings.S.get("LoadStoreErrorInReadTransaction")).append("\n");
            } else {
                s.append(Strings.S.get("LoadStoreErrorInWriteTransaction")).append("\n");
            }
            s.append(trans.getErrorMessage());
            this.errorMessage = s.toString();
        }
        return trans.hasError();
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(Nios2State.registerABINames[this.destination]).append(",").append(this.immediate).append("(");
        s.append(Nios2State.registerABINames[this.base]).append(")");
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        this.valid = false;
        if (!this.Opcodes.contains(instr.getOpcode().toLowerCase())) {
            return false;
        }
        this.operation = this.Opcodes.indexOf(instr.getOpcode().toLowerCase());
        this.valid = true;
        if (instr.getNrOfParameters() != 2) {
            this.valid = false;
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
            return true;
        }
        AssemblerToken[] param2 = instr.getParameter(1);
        this.valid &= Nios2Support.isCorrectRegister(instr, 0);
        this.destination = Nios2Support.getRegisterIndex(instr, 0);
        if (param2.length != 2) {
            this.valid = false;
            instr.setError(param2[0], Strings.S.getter("Nios2AssemblerExpectedImmediateIndexedRegister"));
        }
        if (!this.valid) {
            return true;
        }
        if (!param2[0].isNumber()) {
            this.valid = false;
            instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
        }
        if (param2[1].getType() != 4) {
            this.valid = false;
            instr.setError(param2[1], Strings.S.getter("Nios2AssemblerExpectedBracketedRegister"));
        }
        if (!this.valid) {
            return true;
        }
        if (Nios2State.isCustomRegister(param2[1].getValue())) {
            this.valid = false;
            instr.setError(param2[1], Strings.S.getter("Nios2CannotUseCustomRegister"));
        }
        if (Nios2State.isControlRegister(param2[1].getValue())) {
            this.valid = false;
            instr.setError(param2[1], Strings.S.getter("Nios2CannotUseControlRegister"));
        }
        this.base = Nios2State.getRegisterIndex(param2[1].getValue());
        if (this.base < 0 || this.base > 31) {
            this.valid = false;
            instr.setError(param2[1], Strings.S.getter("AssemblerUnknownRegister"));
        }
        this.immediate = param2[0].getNumberValue();
        if (this.immediate >= 32768 || this.immediate < Short.MIN_VALUE) {
            this.valid = false;
            instr.setError(param2[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
        }
        if (!this.valid) {
            return true;
        }
        this.instruction = Nios2Support.getITypeInstructionCode(this.base, this.destination, this.immediate, this.OpcCodes.get(this.operation));
        instr.setInstructionByteCode(this.instruction, 4);
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.valid = false;
        int opc = Nios2Support.getOpcode(instr);
        if (!this.OpcCodes.contains(opc)) {
            return false;
        }
        this.valid = true;
        this.instruction = instr;
        this.operation = this.OpcCodes.indexOf(opc);
        this.immediate = Nios2Support.getImmediate(instr, 0);
        if ((this.immediate >> 15 & 1) != 0) {
            this.immediate |= 0xFFFF0000;
        }
        this.base = Nios2Support.getRegAIndex(instr, 0);
        this.destination = Nios2Support.getRegBIndex(instr, 0);
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return this.Opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.Opcodes.contains(instruction.toLowerCase())) {
            return 4;
        }
        return -1;
    }
}

