/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.file;

import com.cburch.logisim.soc.file.ElfHeader;

public class SymbolTable {
    public static final int ST_NAME = 0;
    public static final int ST_VALUE = 1;
    public static final int ST_SIZE = 2;
    public static final int ST_INFO = 3;
    public static final int ST_OTHER = 4;
    public static final int ST_SHNDX = 5;
    public static final int STB_LOCAL = 0;
    public static final int STB_GLOBAL = 1;
    public static final int STB_WEAK = 2;
    public static final int STB_LOPROC = 13;
    public static final int STB_HIPROC = 15;
    public static final int STT_NOTYPE = 0;
    public static final int STT_OBJECT = 1;
    public static final int STT_FUNC = 2;
    public static final int STT_SECTION = 3;
    public static final int STT_FILE = 4;
    public static final int STT_LOPROC = 13;
    public static final int STT_HIPROC = 15;
    public static final int SYMBOL_TABLE_SIZE = 16;
    private final Integer stName;
    private final Integer stValue;
    private final Integer stSize;
    private final Integer stInfo;
    private final Integer stOther;
    private final Integer stShndx;
    private String name;

    public SymbolTable(byte[] buffer, boolean isLittleEndian, int offset) {
        int index = offset;
        this.stName = ElfHeader.getIntValue(buffer, index, 4, isLittleEndian);
        this.stValue = ElfHeader.getIntValue(buffer, index += 4, 4, isLittleEndian);
        this.stSize = ElfHeader.getIntValue(buffer, index += 4, 4, isLittleEndian);
        index += 4;
        this.stInfo = buffer[index++] & 0xFF;
        this.stOther = buffer[index++] & 0xFF;
        this.stShndx = ElfHeader.getIntValue(buffer, index, 2, isLittleEndian);
        this.name = "";
    }

    public SymbolTable(String name, int addr) {
        this.name = name;
        this.stName = 0;
        this.stValue = addr;
        this.stSize = name.length() + 1;
        this.stInfo = 2;
        this.stOther = 0;
        this.stShndx = 0;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public int getStType() {
        return this.stInfo & 0xF;
    }

    public int getStBind() {
        return this.stInfo >> 4 & 0xF;
    }

    public Integer getValue(int identifier) {
        return switch (identifier) {
            case 0 -> this.stName;
            case 1 -> this.stValue;
            case 2 -> this.stSize;
            case 3 -> this.stInfo;
            case 4 -> this.stOther;
            case 5 -> this.stShndx;
            default -> null;
        };
    }
}

