/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.start.SplashScreen;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectBundleManifest;
import com.cburch.logisim.proj.ProjectBundleReadme;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.proj.Strings;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.LibraryTools;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.JFileChoosers;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class ProjectActions {
    private static final String FILE_NAME_FORMAT_ERROR = "FileNameError";
    private static final String FILE_NAME_KEYWORD_ERROR = "ExistingToolName";

    private ProjectActions() {
    }

    private static boolean checkValidFilename(String filename, Project proj, HashMap<String, String> errors) {
        boolean isOk = true;
        HashMap<String, Library> tempSet = new HashMap<String, Library>();
        HashSet<String> forbiddenNames = new HashSet<String>();
        LibraryTools.buildLibraryList(proj.getLogisimFile(), tempSet);
        LibraryTools.buildToolList((Library)proj.getLogisimFile(), forbiddenNames);
        forbiddenNames.addAll(tempSet.keySet());
        Pattern pattern = Pattern.compile("[^a-z\\d_.]", 2);
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find()) {
            isOk = false;
            errors.put(FILE_NAME_FORMAT_ERROR, Strings.S.get("InvalidFileFormatError"));
        }
        if (forbiddenNames.contains(filename.toUpperCase())) {
            isOk = false;
            errors.put(FILE_NAME_KEYWORD_ERROR, Strings.S.get("UsedLibraryToolnameError"));
        }
        return isOk;
    }

    private static Project completeProject(SplashScreen monitor, Loader loader, LogisimFile file, boolean isStartup) {
        if (monitor != null) {
            monitor.setProgress(8);
        }
        Project ret = new Project(file);
        if (monitor != null) {
            monitor.setProgress(9);
        }
        SwingUtilities.invokeLater(new CreateFrame(loader, ret, isStartup));
        ProjectActions.updatecircs(file, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogisimFile createEmptyFile(Loader loader, Project proj) {
        LogisimFile file;
        InputStream templReader = AppPreferences.getEmptyTemplate().createStream();
        try {
            file = loader.openLogisimFile(templReader);
        }
        catch (Exception t) {
            file = LogisimFile.createNew(loader, proj);
            file.addCircuit(new Circuit("main", file, proj));
        }
        finally {
            try {
                templReader.close();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    private static Frame createFrame(Project sourceProject, Project newProject) {
        Frame frame;
        if (sourceProject != null && (frame = sourceProject.getFrame()) != null) {
            frame.savePreferences();
        }
        Frame newFrame = new Frame(newProject);
        newProject.setFrame(newFrame);
        return newFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogisimFile createNewFile(Project baseProject) {
        LogisimFile file;
        Frame parent = baseProject == null ? null : baseProject.getFrame();
        Loader loader = new Loader(parent);
        InputStream templReader = AppPreferences.getTemplate().createStream();
        try {
            file = loader.openLogisimFile(templReader);
        }
        catch (IOException ex) {
            ProjectActions.displayException(baseProject.getFrame(), ex);
            file = ProjectActions.createEmptyFile(loader, baseProject);
        }
        finally {
            try {
                templReader.close();
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    private static void displayException(Component parent, Exception ex) {
        String msg = Strings.S.get("templateOpenError", ex.toString());
        String ttl = Strings.S.get("templateOpenErrorTitle");
        OptionPane.showMessageDialog(parent, msg, ttl, 0);
    }

    public static Project doNew(Project baseProject) {
        LogisimFile file = ProjectActions.createNewFile(baseProject);
        Project newProj = new Project(file);
        Frame frame = ProjectActions.createFrame(baseProject, newProj);
        frame.setVisible(true);
        frame.getCanvas().requestFocus();
        newProj.getLogisimFile().getLoader().setParent(frame);
        ProjectActions.updatecircs(file, newProj);
        return newProj;
    }

    public static Project doNew(SplashScreen monitor) {
        return ProjectActions.doNew(monitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project doNew(SplashScreen monitor, boolean isStartupScreen) {
        if (monitor != null) {
            monitor.setProgress(6);
        }
        Loader loader = new Loader(monitor);
        InputStream templReader = AppPreferences.getTemplate().createStream();
        LogisimFile file = null;
        try {
            file = loader.openLogisimFile(templReader);
        }
        catch (IOException ex) {
            ProjectActions.displayException(monitor, ex);
        }
        finally {
            try {
                templReader.close();
            }
            catch (IOException iOException) {}
        }
        if (file == null) {
            file = ProjectActions.createEmptyFile(loader, null);
        }
        return ProjectActions.completeProject(monitor, loader, file, isStartupScreen);
    }

    public static void doMerge(Component parent, Project baseProject) {
        LogisimFile mergelib;
        JFileChooser chooser;
        if (baseProject != null) {
            Loader oldLoader = baseProject.getLogisimFile().getLoader();
            chooser = oldLoader.createChooser();
            if (oldLoader.getMainFile() != null) {
                chooser.setSelectedFile(oldLoader.getMainFile());
            }
        } else {
            chooser = JFileChoosers.create();
        }
        chooser.setFileFilter(Loader.LOGISIM_FILTER);
        chooser.setDialogTitle(Strings.S.get("FileMergeItem"));
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal != 0) {
            return;
        }
        File selected = chooser.getSelectedFile();
        Loader loader = new Loader(baseProject == null ? parent : baseProject.getFrame());
        try {
            mergelib = loader.openLogisimFile(selected);
            if (mergelib == null) {
                return;
            }
        }
        catch (LoadFailedException ex) {
            if (!ex.isShown()) {
                OptionPane.showMessageDialog(parent, Strings.S.get("fileMergeError", ex.toString()), Strings.S.get("FileMergeErrorItem"), 0);
            }
            return;
        }
        baseProject.doAction(LogisimFileActions.mergeFile(mergelib, baseProject.getLogisimFile()));
    }

    private static void updatecircs(LogisimFile lib, Project proj) {
        for (Circuit circ : lib.getCircuits()) {
            circ.setProject(proj);
        }
        for (Library libs : lib.getLibraries()) {
            LoadedLibrary test;
            Library library;
            if (!(libs instanceof LoadedLibrary) || !((library = (test = (LoadedLibrary)libs).getBase()) instanceof LogisimFile)) continue;
            LogisimFile lsFile = (LogisimFile)library;
            ProjectActions.updatecircs(lsFile, proj);
        }
    }

    public static Project doOpen(Component parent, Project baseProject) {
        JFileChooser chooser;
        if (baseProject != null) {
            Loader oldLoader = baseProject.getLogisimFile().getLoader();
            chooser = oldLoader.createChooser();
            if (oldLoader.getMainFile() != null) {
                chooser.setSelectedFile(oldLoader.getMainFile());
            }
        } else {
            chooser = JFileChoosers.create();
        }
        chooser.setFileFilter(Loader.LOGISIM_FILTER);
        chooser.setDialogTitle(Strings.S.get("FileOpenItem"));
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal != 0) {
            return null;
        }
        File selected = chooser.getSelectedFile();
        if (selected == null) {
            return null;
        }
        return ProjectActions.doOpen(parent, baseProject, selected);
    }

    public static Project doOpen(Component parent, Project baseProject, File f) {
        Project proj = Projects.findProjectFor(f);
        Loader loader = null;
        if (proj != null) {
            proj.getFrame().toFront();
            loader = proj.getLogisimFile().getLoader();
            if (proj.isFileDirty()) {
                String message = Strings.S.get("openAlreadyMessage", proj.getLogisimFile().getName());
                Object[] options = new String[]{Strings.S.get("openAlreadyLoseChangesOption"), Strings.S.get("openAlreadyNewWindowOption"), Strings.S.get("openAlreadyCancelOption")};
                int result = OptionPane.showOptionDialog(proj.getFrame(), message, Strings.S.get("openAlreadyTitle"), 0, 3, null, options, options[2]);
                if (result != 0) {
                    if (result == 1) {
                        proj = null;
                    } else {
                        return proj;
                    }
                }
            }
        }
        if (proj == null && baseProject != null && baseProject.isStartupScreen()) {
            proj = baseProject;
            proj.setStartupScreen(false);
            loader = baseProject.getLogisimFile().getLoader();
        } else {
            loader = new Loader(baseProject == null ? parent : baseProject.getFrame());
        }
        try {
            LogisimFile lib = loader.openLogisimFile(f);
            AppPreferences.updateRecentFile(f);
            if (lib == null) {
                return null;
            }
            LibraryTools.removePresentLibraries(lib, new HashMap<String, Library>(), true);
            if (proj == null) {
                proj = new Project(lib);
                ProjectActions.updatecircs(lib, proj);
            } else {
                ProjectActions.updatecircs(lib, proj);
                proj.setLogisimFile(lib);
            }
        }
        catch (LoadFailedException ex) {
            if (!ex.isShown()) {
                OptionPane.showMessageDialog(parent, Strings.S.get("fileOpenError", ex.toString()), Strings.S.get("fileOpenErrorTitle"), 0);
            }
            return null;
        }
        Frame frame = proj.getFrame();
        if (frame == null) {
            frame = ProjectActions.createFrame(baseProject, proj);
        }
        frame.setVisible(true);
        frame.toFront();
        frame.getCanvas().requestFocus();
        proj.getLogisimFile().getLoader().setParent(frame);
        return proj;
    }

    public static Project doOpen(SplashScreen monitor, File source, Map<File, File> substitutions) throws LoadFailedException {
        if (monitor != null) {
            monitor.setProgress(7);
        }
        Loader loader = new Loader(monitor);
        LogisimFile file = loader.openLogisimFile(source, substitutions);
        AppPreferences.updateRecentFile(source);
        return ProjectActions.completeProject(monitor, loader, file, false);
    }

    public static Project doOpenNoWindow(SplashScreen monitor, File source) throws LoadFailedException {
        Loader loader = new Loader(monitor);
        LogisimFile file = loader.openLogisimFile(source);
        Project ret = new Project(file);
        ProjectActions.updatecircs(file, ret);
        return ret;
    }

    public static void doQuit() {
        Frame top = Projects.getTopFrame();
        top.savePreferences();
        for (Project proj : new ArrayList<Project>(Projects.getOpenProjects())) {
            if (proj.confirmClose(Strings.S.get("confirmQuitTitle"))) continue;
            return;
        }
        System.exit(0);
    }

    public static boolean doSave(Project proj) {
        Loader loader = proj.getLogisimFile().getLoader();
        File f = loader.getMainFile();
        if (f == null) {
            return ProjectActions.doSaveAs(proj);
        }
        return ProjectActions.doSave(proj, f);
    }

    public static boolean doSave(Project proj, File f) {
        Loader loader = proj.getLogisimFile().getLoader();
        Tool oldTool = proj.getTool();
        proj.setTool(null);
        boolean ret = loader.save(proj.getLogisimFile(), f);
        if (ret) {
            AppPreferences.updateRecentFile(f);
            proj.setFileAsClean();
        }
        proj.setTool(oldTool);
        return ret;
    }

    public static boolean doExtractAndRunProject(Project proj) {
        boolean ret = true;
        Loader loader = proj.getLogisimFile().getLoader();
        JFileChooser chooser = loader.createChooser();
        boolean isCorrectFile = true;
        do {
            chooser.setFileFilter(Loader.LOGISIM_BUNDLE_FILTER);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(Strings.S.get("projImportBundle"));
            if (!(ret &= chooser.showOpenDialog(proj.getFrame()) == 0)) {
                return ret;
            }
            String zipFileName = chooser.getSelectedFile().getAbsolutePath();
            isCorrectFile = Files.exists(Paths.get(zipFileName, new String[0]), new LinkOption[0]);
            if (isCorrectFile) {
                try {
                    ZipFile zipFile = new ZipFile(zipFileName);
                    ProjectBundleManifest.infofileInformation bundleInfo = ProjectBundleManifest.getManifestInfo(zipFile, proj.getFrame());
                    if (bundleInfo == null) {
                        return false;
                    }
                    ZipEntry mainFileEntry = zipFile.getEntry(bundleInfo.getMainLogisimFilename());
                    if (mainFileEntry == null) {
                        OptionPane.showMessageDialog(proj.getFrame(), Strings.S.fmt("projBundleReadError", Strings.S.get("projBundleMainNotFound")));
                        return false;
                    }
                    ZipEntry readmeFileEntry = zipFile.getEntry("README.md");
                    if (readmeFileEntry != null) {
                        InputStream readmeInStream = zipFile.getInputStream(readmeFileEntry);
                        ProjectBundleReadme dialog = new ProjectBundleReadme(proj, "");
                        dialog.showReadme(readmeInStream);
                        readmeInStream.close();
                    }
                    chooser.setFileFilter(Loader.LOGISIM_DIRECTORY);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle(Strings.S.get("projBundleDirectory"));
                    boolean isCorrectDirectory = true;
                    do {
                        if (!(ret &= chooser.showOpenDialog(proj.getFrame()) == 0)) {
                            return ret;
                        }
                        String exportDirectory = chooser.getSelectedFile().getAbsolutePath();
                        String mainProjectFileName = String.format("%s%s%s", exportDirectory, File.separator, bundleInfo.getMainLogisimFilename());
                        String filename = mainProjectFileName;
                        if (Files.exists(Paths.get(filename, new String[0]), new LinkOption[0]) || Files.exists(Paths.get(String.format("%s%s%s", exportDirectory, File.separator, "library"), new String[0]), new LinkOption[0])) {
                            isCorrectDirectory = false;
                            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.fmt("projContainsFileDir", bundleInfo.getMainLogisimFilename(), "library"));
                            continue;
                        }
                        isCorrectDirectory = true;
                        InputStream zipInput = zipFile.getInputStream(mainFileEntry);
                        FileOutputStream fileOutput = new FileOutputStream(filename);
                        int data = zipInput.read();
                        while (data > 0) {
                            fileOutput.write(data);
                            data = zipInput.read();
                        }
                        zipInput.close();
                        fileOutput.close();
                        Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
                        String libDir = String.format("%s%s%s", exportDirectory, File.separator, "library");
                        while (zipFileEntries.hasMoreElements()) {
                            ZipEntry entry = zipFileEntries.nextElement();
                            if (entry.isDirectory()) {
                                String dirName = entry.getName();
                                if (!dirName.equals("library")) continue;
                                new File(String.format("%s%s%s", exportDirectory, File.separator, dirName)).mkdirs();
                                continue;
                            }
                            String entryName = entry.getName();
                            if (!entryName.startsWith(String.format("%s%s", "library", File.separator)) || entryName.lastIndexOf(File.separator) != entryName.indexOf(File.separator) || !entryName.endsWith(".circ") && !entryName.toLowerCase().endsWith(".jar")) continue;
                            if (!Files.exists(Paths.get(libDir, new String[0]), new LinkOption[0])) {
                                new File(libDir).mkdirs();
                            }
                            filename = String.format("%s%s%s", exportDirectory, File.separator, entryName);
                            File testFile = new File(filename);
                            File testDir = new File(exportDirectory);
                            if (!testFile.toPath().normalize().startsWith(testDir.toPath())) continue;
                            zipInput = zipFile.getInputStream(entry);
                            fileOutput = new FileOutputStream(filename);
                            byte[] bytes = new byte[1024];
                            int length = 0;
                            while ((length = zipInput.read(bytes)) >= 0) {
                                fileOutput.write(bytes, 0, length);
                            }
                            fileOutput.close();
                            zipInput.close();
                        }
                        ProjectActions.doOpen(proj.getFrame().getCanvas(), proj, new File(mainProjectFileName));
                    } while (!isCorrectDirectory);
                    zipFile.close();
                }
                catch (IOException e) {
                    isCorrectFile = false;
                    OptionPane.showMessageDialog(proj.getFrame(), Strings.S.fmt("fileOpenError", String.format("%s\n%s", zipFileName, e.getMessage())));
                }
                continue;
            }
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.fmt("fileOpenError", zipFileName));
        } while (!isCorrectFile);
        return ret;
    }

    public static boolean doExportProject(Project proj) {
        boolean ret = true;
        Loader loader = proj.getLogisimFile().getLoader();
        Tool oldTool = proj.getTool();
        proj.setTool(null);
        String mainFileName = loader.getMainFile() == null ? "Untitled.circ" : loader.getMainFile().getName();
        String zipFile = mainFileName.replace(".circ", ".lsebdl");
        JFileChooser chooser = loader.createChooser();
        chooser.setFileFilter(Loader.LOGISIM_BUNDLE_FILTER);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setSelectedFile(new File(zipFile));
        chooser.setDialogTitle(Strings.S.get("projExportBundle"));
        boolean isCorrectFile = true;
        do {
            if (!(ret &= chooser.showSaveDialog(proj.getFrame()) == 0)) {
                proj.setTool(oldTool);
                return false;
            }
            try {
                Path path;
                zipFile = chooser.getSelectedFile().getAbsolutePath();
                if (!zipFile.endsWith(".lsebdl")) {
                    zipFile = zipFile.concat(".lsebdl");
                }
                if (!(isCorrectFile = Files.exists(path = Paths.get(zipFile, new String[0]), new LinkOption[0]) ? OptionPane.showConfirmDialog(proj.getFrame(), Strings.S.fmt("projExistsOverwrite", new File(zipFile).getName()), Strings.S.get("projExportBundle"), 0) == 0 : true)) continue;
                ProjectBundleReadme dialog = new ProjectBundleReadme(proj, mainFileName.replace(".circ", ""));
                ProjectBundleReadme.ReadmeInfo readmeInfo = dialog.getReadmeInfo();
                if (readmeInfo == null) {
                    return false;
                }
                FileOutputStream projectFile = new FileOutputStream(zipFile);
                ZipOutputStream projectZipFile = new ZipOutputStream(projectFile);
                ProjectBundleReadme.writeReadmeFile(projectZipFile, readmeInfo);
                projectZipFile.putNextEntry(new ZipEntry(String.format("%s%s", "library", File.separator)));
                mainFileName = chooser.getSelectedFile().getName().replace(".lsebdl", "").concat(".circ");
                ret &= loader.export(proj.getLogisimFile(), projectZipFile, mainFileName);
                ProjectBundleManifest.infofileInformation info = ProjectBundleManifest.getInfoContainer("Logisim-evolution v4.0.0", mainFileName);
                ProjectBundleManifest.writeManifest(projectZipFile, info);
                projectZipFile.close();
                projectFile.close();
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("ProjUnableToCreate", e.getMessage()));
                proj.setTool(oldTool);
                return false;
            }
        } while (!isCorrectFile);
        proj.setTool(oldTool);
        return ret;
    }

    public static boolean doSaveAs(Project proj) {
        int confirm;
        Loader loader = proj.getLogisimFile().getLoader();
        JFileChooser chooser = loader.createChooser();
        chooser.setFileFilter(Loader.LOGISIM_FILTER);
        if (loader.getMainFile() != null) {
            chooser.setSelectedFile(loader.getMainFile());
        }
        boolean validFilename = false;
        HashMap<String, String> errors = new HashMap<String, String>();
        do {
            errors.clear();
            int returnVal = chooser.showSaveDialog(proj.getFrame());
            if (returnVal != 0) {
                return false;
            }
            validFilename = ProjectActions.checkValidFilename(chooser.getSelectedFile().getName(), proj, errors);
            if (validFilename) continue;
            Object message = "\"" + String.valueOf(chooser.getSelectedFile()) + "\":\n";
            for (String key : errors.keySet()) {
                message = ((String)message).concat("=> " + Strings.S.get(errors.get(key)) + "\n");
            }
            OptionPane.showMessageDialog(chooser, message, Strings.S.get("FileSaveAsItem"), 0);
        } while (!validFilename);
        File selectedFile = chooser.getSelectedFile();
        if (!selectedFile.getName().endsWith(".circ")) {
            String old = selectedFile.getName();
            int ext0 = old.lastIndexOf(46);
            if (ext0 < 0 || !Pattern.matches("\\.\\p{L}{2,}\\d?", old.substring(ext0))) {
                selectedFile = new File(selectedFile.getParentFile(), old + ".circ");
            } else {
                String ext = old.substring(ext0);
                String ttl = Strings.S.get("replaceExtensionTitle");
                String msg = Strings.S.get("replaceExtensionMessage", ext);
                Object[] options = new Object[]{Strings.S.get("replaceExtensionReplaceOpt", ext), Strings.S.get("replaceExtensionAddOpt", ".circ"), Strings.S.get("replaceExtensionKeepOpt")};
                JOptionPane dlog = new JOptionPane(msg);
                dlog.setMessageType(3);
                dlog.setOptions(options);
                dlog.createDialog(proj.getFrame(), ttl).setVisible(true);
                Object result = dlog.getValue();
                if (result == options[0]) {
                    String name = old.substring(0, ext0) + ".circ";
                    selectedFile = new File(selectedFile.getParentFile(), name);
                } else if (result == options[1]) {
                    selectedFile = new File(selectedFile.getParentFile(), old + ".circ");
                }
            }
        }
        if (selectedFile.exists() && (confirm = OptionPane.showConfirmDialog(proj.getFrame(), Strings.S.get("confirmOverwriteMessage"), Strings.S.get("confirmOverwriteTitle"), 0)) != 0) {
            return false;
        }
        return ProjectActions.doSave(proj, selectedFile);
    }

    private static class CreateFrame
    implements Runnable {
        private final Loader loader;
        private final Project proj;
        private final boolean isStartupScreen;

        public CreateFrame(Loader loader, Project proj, boolean isStartup) {
            this.loader = loader;
            this.proj = proj;
            this.isStartupScreen = isStartup;
        }

        @Override
        public void run() {
            try {
                Frame frame = ProjectActions.createFrame(null, this.proj);
                frame.setVisible(true);
                frame.toFront();
                frame.getCanvas().requestFocus();
                this.loader.setParent(frame);
                if (this.isStartupScreen) {
                    this.proj.setStartupScreen(true);
                }
            }
            catch (Exception e) {
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                OptionPane.showMessageDialog(null, result.toString());
                System.exit(-1);
            }
        }
    }
}

