/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.draw.toolbar.AbstractToolbarModel;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.draw.toolbar.ToolbarSeparator;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.ToolbarData;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.InputEventUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class LayoutToolbarModel
extends AbstractToolbarModel {
    private final Frame frame;
    private final Project proj;
    private final MyListener myListener;
    private List<ToolbarItem> items;
    private Tool haloedTool;

    public LayoutToolbarModel(Frame frame, Project proj) {
        this.frame = frame;
        this.proj = proj;
        this.myListener = new MyListener();
        this.items = Collections.emptyList();
        this.haloedTool = null;
        this.buildContents();
        ToolbarData data = proj.getOptions().getToolbarData();
        data.addToolbarListener(this.myListener);
        data.addToolAttributeListener(this.myListener);
        AppPreferences.GATE_SHAPE.addPropertyChangeListener(this.myListener);
        proj.addProjectListener(this.myListener);
    }

    private static ToolbarItem findItem(List<ToolbarItem> items, Tool tool) {
        for (ToolbarItem item : items) {
            if (!(item instanceof ToolItem)) continue;
            ToolItem toolItem = (ToolItem)item;
            if (tool != toolItem.tool) continue;
            return item;
        }
        return null;
    }

    private void buildContents() {
        List<ToolbarItem> oldItems = this.items;
        ArrayList<ToolbarItem> newItems = new ArrayList<ToolbarItem>();
        ToolbarData data = this.proj.getLogisimFile().getOptions().getToolbarData();
        for (Tool tool : data.getContents()) {
            if (tool == null) {
                newItems.add(new ToolbarSeparator(4));
                continue;
            }
            ToolbarItem i = LayoutToolbarModel.findItem(oldItems, tool);
            newItems.add(Objects.requireNonNullElseGet(i, () -> new ToolItem(tool)));
        }
        this.items = Collections.unmodifiableList(newItems);
        this.fireToolbarContentsChanged();
    }

    @Override
    public List<ToolbarItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isSelected(ToolbarItem item) {
        boolean bl;
        if (item instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)item;
            bl = toolItem.tool == this.proj.getTool();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void itemSelected(ToolbarItem item) {
        if (item instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)item;
            this.proj.setTool(toolItem.tool);
        }
    }

    public void setHaloedTool(Tool t) {
        if (this.haloedTool != t) {
            this.haloedTool = t;
            this.fireToolbarAppearanceChanged();
        }
    }

    private class MyListener
    implements ProjectListener,
    AttributeListener,
    ToolbarData.ToolbarListener,
    PropertyChangeListener {
        private MyListener() {
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            LayoutToolbarModel.this.fireToolbarAppearanceChanged();
        }

        @Override
        public void projectChanged(ProjectEvent e) {
            int act = e.getAction();
            if (act == 2) {
                LayoutToolbarModel.this.fireToolbarAppearanceChanged();
            } else if (act == 0) {
                LogisimFile file;
                LogisimFile old = (LogisimFile)e.getOldData();
                if (old != null) {
                    ToolbarData data = old.getOptions().getToolbarData();
                    data.removeToolbarListener(this);
                    data.removeToolAttributeListener(this);
                }
                if ((file = (LogisimFile)e.getData()) != null) {
                    ToolbarData data = file.getOptions().getToolbarData();
                    data.addToolbarListener(this);
                    data.addToolAttributeListener(this);
                }
                LayoutToolbarModel.this.buildContents();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (AppPreferences.GATE_SHAPE.isSource(event)) {
                LayoutToolbarModel.this.fireToolbarAppearanceChanged();
            }
        }

        @Override
        public void toolbarChanged() {
            LayoutToolbarModel.this.buildContents();
        }
    }

    private class ToolItem
    implements ToolbarItem {
        private final Tool tool;

        ToolItem(Tool tool) {
            this.tool = tool;
        }

        @Override
        public Dimension getDimension(Object orientation) {
            int pad = 4;
            return new Dimension(AppPreferences.getIconSize() + 4, AppPreferences.getIconSize() + 4);
        }

        @Override
        public String getToolTip() {
            Object ret = this.tool.getDescription();
            int index = 1;
            for (ToolbarItem item : LayoutToolbarModel.this.items) {
                if (item == this) break;
                if (!(item instanceof ToolItem)) continue;
                ++index;
            }
            if (index <= 10) {
                if (index == 10) {
                    index = 0;
                }
                int mask = LayoutToolbarModel.this.frame.getToolkit().getMenuShortcutKeyMaskEx();
                ret = (String)ret + " (" + InputEventUtil.toKeyDisplayString(mask) + "-" + index + ")";
            }
            return ret;
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public void paintIcon(Component destination, Graphics gfx) {
            if (this.tool == LayoutToolbarModel.this.haloedTool && AppPreferences.ATTRIBUTE_HALO.getBoolean()) {
                gfx.setColor(Canvas.HALO_COLOR);
                gfx.fillRect(2, 2, AppPreferences.getIconSize(), AppPreferences.getIconSize());
            }
            gfx.setColor(new Color(AppPreferences.COMPONENT_ICON_COLOR.get()));
            Graphics gfxCopy = gfx.create();
            ComponentDrawContext c = new ComponentDrawContext(destination, null, null, gfx, gfxCopy);
            this.tool.paintIcon(c, 2, 2);
            gfxCopy.dispose();
        }
    }
}

