/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.log.ClockSource;
import com.cburch.logisim.gui.log.ComponentSelector;
import com.cburch.logisim.gui.log.LogThread;
import com.cburch.logisim.gui.log.LoggableContract;
import com.cburch.logisim.gui.log.Signal;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.EventSourceWeakSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Model
implements CircuitListener,
SignalInfo.Listener {
    public static final int STEP = 10;
    public static final int REAL = 20;
    private static final int CLOCKED = 30;
    public static final int CLOCK_DUAL = 30;
    public static final int CLOCK_RISING = 40;
    public static final int CLOCK_FALLING = 50;
    public static final int CLOCK_HIGH = 60;
    public static final int CLOCK_LOW = 70;
    public static final int COARSE = 1;
    public static final int FINE = 2;
    final CircuitState circuitState;
    private final ArrayList<SignalInfo> info = new ArrayList();
    private final ArrayList<Signal> signals = new ArrayList();
    private long timeEnd = -1L;
    private Signal spotlight;
    private SignalInfo clockSource;
    private Value curClockVal;
    private final EventSourceWeakSupport<Listener> listeners = new EventSourceWeakSupport();
    private boolean fileEnabled = false;
    private File file = null;
    private boolean fileHeader = true;
    private boolean selected = false;
    private LogThread logger = null;
    private int mode = 10;
    private int granularity = 1;
    private long timeScale = 5000L;
    private long gateDelay = 200L;
    private int historyLimit = 400;
    private long elapsedSinceTrigger;
    private long lastRealtimeUpdate;
    private static final Value HI = Value.TRUE;
    private static final Value LO = Value.FALSE;

    public Model(CircuitState root) {
        Component clk;
        SignalInfo item;
        this.circuitState = root;
        Circuit circ = this.circuitState.getCircuit();
        for (Component comp : circ.getNonWires()) {
            item = this.makeIfDefaultComponent(comp);
            if (item == null) continue;
            this.info.add(item);
        }
        Location.sortHorizontal(this.info);
        int n = this.info.size();
        for (int i = 0; i < n; ++i) {
            item = this.info.get(i);
            if (item.isInput(null)) continue;
            this.info.add(this.info.remove(i));
            --i;
            --n;
        }
        ArrayList<SignalInfo> clocks = ComponentSelector.findClocks(circ);
        if (clocks != null && clocks.size() == 1) {
            this.clockSource = clocks.get(0);
        } else if (clocks != null && clocks.size() > 1) {
            this.clockSource = ClockSource.doClockMultipleObserverDialog(circ);
            if (this.clockSource != null && this.clockSource.getComponent().getFactory() instanceof Pin && this.clockSource.getDepth() == 1) {
                this.circuitState.setTemporaryClock(this.clockSource.getComponent());
            }
        }
        if (this.clockSource == null && (clk = this.circuitState.getTemporaryClock()) != null) {
            this.clockSource = new SignalInfo(circ, new Component[]{clk}, null);
        }
        if (this.clockSource != null) {
            if (!this.info.contains(this.clockSource)) {
                this.info.add(0, this.clockSource);
            } else {
                this.info.add(0, this.info.remove(this.info.indexOf(this.clockSource)));
            }
            this.mode = 30;
            this.curClockVal = this.clockSource.fetchValue(this.circuitState);
        }
        long duration = this.captureContinuous() ? this.gateDelay : this.timeScale;
        for (int i = 0; i < this.info.size(); ++i) {
            SignalInfo item2 = this.info.get(i);
            this.signals.add(new Signal(i, item2, item2.fetchValue(this.circuitState), duration, 0L, this.historyLimit));
        }
        this.timeEnd = duration;
        for (SignalInfo item2 : this.info) {
            item2.setListener(this);
        }
        circ.addCircuitListener(this);
    }

    private void renumberSignals() {
        for (int i = 0; i < this.signals.size(); ++i) {
            this.signals.get((int)i).idx = i;
        }
    }

    public void addOrMove(List<SignalInfo> items, int idx) {
        int changed = items.size();
        for (SignalInfo item : items) {
            int i = this.info.indexOf(item);
            if (i < 0) {
                this.info.add(idx, item);
                this.signals.add(idx, new Signal(idx, item, item.fetchValue(this.circuitState), 1L, this.timeEnd - 1L, this.historyLimit));
                ++idx;
                continue;
            }
            if (i > idx) {
                this.info.add(idx, this.info.remove(i));
                this.signals.add(idx, this.signals.remove(i));
                ++idx;
                item.setListener(this);
                continue;
            }
            if (i < idx) {
                this.info.add(idx - 1, this.info.remove(i));
                this.signals.add(idx - 1, this.signals.remove(i));
                continue;
            }
            --changed;
        }
        if (changed > 0) {
            this.renumberSignals();
            this.fireSelectionChanged(null);
        }
    }

    public boolean addOrMoveSignals(List<Signal> items, int idx) {
        int changed = items.size();
        long newEnd = this.timeEnd;
        for (Signal item : items) {
            if (item.info.getTopLevelCircuit() != this.getCircuit()) {
                --changed;
                continue;
            }
            int i = this.info.indexOf(item.info);
            if (i < 0) {
                this.info.add(idx, item.info);
                item.resize(this.historyLimit);
                long d = item.getEndTime();
                if (d < newEnd) {
                    item.extend(newEnd - d);
                } else if (d > newEnd) {
                    for (Signal s : this.signals) {
                        s.extend(d - newEnd);
                    }
                    newEnd = d;
                }
                this.signals.add(idx, item);
                ++idx;
                item.info.setListener(this);
                continue;
            }
            if (i > idx) {
                this.info.add(idx, this.info.remove(i));
                this.signals.add(idx, this.signals.remove(i));
                ++idx;
                continue;
            }
            if (i < idx - 1) {
                this.info.add(idx - 1, this.info.remove(i));
                this.signals.add(idx - 1, this.signals.remove(i));
                continue;
            }
            --changed;
        }
        if (changed == 0 && newEnd == this.timeEnd) {
            return false;
        }
        this.timeEnd = newEnd;
        this.renumberSignals();
        this.fireSelectionChanged(null);
        return true;
    }

    @Override
    public void signalInfoNameChanged(SignalInfo s) {
        this.fireSelectionChanged(null);
    }

    @Override
    public void signalInfoObsoleted(SignalInfo s) {
        if (s == this.clockSource) {
            this.clockSource.setListener(null);
            this.clockSource = null;
            if (this.mode >= 30) {
                this.setStepMode(this.isFine(), this.timeScale, this.gateDelay);
            }
        }
        this.remove(s);
    }

    public int remove(List<SignalInfo> items) {
        int count = 0;
        for (SignalInfo item : items) {
            int idx = this.info.indexOf(item);
            if (idx < 0) continue;
            this.info.remove(idx);
            this.signals.remove(idx);
            ++count;
            item.setListener(null);
        }
        if (count > 0) {
            if (this.spotlight != null && items.contains(this.spotlight)) {
                this.spotlight = null;
            }
            this.renumberSignals();
            this.fireSelectionChanged(null);
        }
        return count;
    }

    public void remove(int idx) {
        if (this.spotlight != null && this.signals.get(idx) == this.spotlight) {
            this.spotlight = null;
        }
        this.info.remove(idx).setListener(null);
        this.signals.remove(idx);
        this.renumberSignals();
        this.fireSelectionChanged(null);
    }

    public void remove(SignalInfo item) {
        this.remove(this.info.indexOf(item));
    }

    public void move(int[] fromIndex, int toIndex) {
        int i;
        int n = fromIndex.length;
        if (n == 0) {
            return;
        }
        Arrays.sort(fromIndex);
        int a = fromIndex[0];
        int b = fromIndex[n - 1];
        if (a < 0 || b > this.info.size()) {
            return;
        }
        if (a <= toIndex && toIndex <= b && b - a + 1 == n) {
            return;
        }
        ArrayList<SignalInfo> items = new ArrayList<SignalInfo>();
        ArrayList<Signal> vals = new ArrayList<Signal>();
        for (i = n - 1; i >= 0; --i) {
            if (fromIndex[i] < toIndex) {
                --toIndex;
            }
            items.add(this.info.remove(fromIndex[i]));
            vals.add(this.signals.remove(fromIndex[i]));
        }
        for (i = n - 1; i >= 0; --i) {
            this.info.add(toIndex, (SignalInfo)items.get(i));
            this.signals.add(toIndex, (Signal)vals.get(i));
            ++toIndex;
        }
        this.renumberSignals();
        this.fireSelectionChanged(null);
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public long getGateDelay() {
        return this.gateDelay;
    }

    public boolean isStepMode() {
        return this.mode == 10;
    }

    public boolean isRealMode() {
        return this.mode == 20;
    }

    public boolean isClockMode() {
        return this.mode >= 30;
    }

    public int getClockDiscipline() {
        return this.mode >= 30 ? this.mode : 0;
    }

    public boolean isFine() {
        return this.granularity == 2;
    }

    public boolean isCoarse() {
        return this.granularity != 2;
    }

    private boolean captureContinuous() {
        return this.isFine() || this.mode == 60 && this.curClockVal.equals(HI) || this.mode == 70 && this.curClockVal.equals(LO);
    }

    public int getHistoryLimit() {
        return this.historyLimit;
    }

    public void setHistoryLimit(int limit) {
        if (this.historyLimit == limit) {
            return;
        }
        this.historyLimit = limit;
        for (Signal s : this.signals) {
            s.resize(this.historyLimit);
        }
        this.fireHistoryLimitChanged(null);
    }

    public void setStepMode(boolean fine, long t, long d) {
        int g;
        int n = g = fine ? 2 : 1;
        if (this.mode == 10 && this.granularity == g && this.timeScale == t && this.gateDelay == d) {
            return;
        }
        this.timeScale = t;
        this.gateDelay = d;
        this.setMode(10, g);
    }

    public void setRealMode(long t, boolean fine) {
        int g;
        int n = g = fine ? 2 : 1;
        if (this.mode == 20 && this.granularity == g && this.timeScale == t) {
            return;
        }
        this.timeScale = t;
        this.setMode(20, g);
    }

    public void setClockMode(boolean fine, int discipline, long t, long d) {
        int g;
        int n = g = fine ? 2 : 1;
        if (this.clockSource != null && this.mode == discipline && this.granularity == g && this.timeScale == t && this.gateDelay == d) {
            return;
        }
        if (this.clockSource == null) {
            Circuit circ = this.circuitState.getCircuit();
            Component tmpClk = this.circuitState.getTemporaryClock();
            ArrayList<SignalInfo> clocks = ComponentSelector.findClocks(circ);
            if (clocks != null && clocks.size() == 1) {
                this.clockSource = clocks.get(0);
            } else if (clocks != null && clocks.size() > 1) {
                this.clockSource = ClockSource.doClockMultipleObserverDialog(circ);
            } else if (tmpClk != null) {
                this.clockSource = new SignalInfo(circ, new Component[]{tmpClk}, null);
            } else if (clocks != null) {
                this.clockSource = ClockSource.doClockMissingObserverDialog(circ);
            }
            if (this.clockSource == null) {
                this.setMode(this.mode, this.granularity);
                return;
            }
            if (this.clockSource.getComponent().getFactory() instanceof Pin && this.clockSource.getDepth() == 1) {
                this.circuitState.setTemporaryClock(this.clockSource.getComponent());
            }
            if (!this.info.contains(this.clockSource)) {
                this.info.add(0, this.clockSource);
                this.signals.add(0, new Signal(0, this.clockSource, this.clockSource.fetchValue(this.circuitState), 1L, this.timeEnd - 1L, this.historyLimit));
                this.clockSource.setListener(this);
                this.fireSelectionChanged(null);
            }
        }
        this.timeScale = t;
        this.gateDelay = d;
        this.setMode(discipline, g);
    }

    private void setMode(int m, int g) {
        this.mode = m;
        this.granularity = g;
        this.simulatorReset();
        this.fireSignalsExtended(null);
        this.fireModeChanged(null);
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        int action = event.getAction();
        if (action == 6) {
            Circuit circ = this.circuitState.getCircuit();
            ReplacementMap repl = event.getResult().getReplacementMap(circ);
            if (repl == null || repl.isEmpty()) {
                return;
            }
            for (Component component : repl.getAdditions()) {
                SignalInfo item;
                if (!repl.getReplacedBy(component).isEmpty() || (item = this.makeIfDefaultComponent(component)) == null) continue;
                this.addAndInitialize(item, true);
            }
        }
    }

    private SignalInfo makeIfDefaultComponent(Component comp) {
        if (comp.getFactory() instanceof SubcircuitFactory) {
            return null;
        }
        LoggableContract log = (LoggableContract)comp.getFeature(LoggableContract.class);
        if (log == null) {
            return null;
        }
        Object[] opts = log.getLogOptions();
        if (opts != null && opts.length > 0) {
            return null;
        }
        Component[] path = new Component[]{comp};
        return new SignalInfo(this.circuitState.getCircuit(), path, null);
    }

    private Signal addAndInitialize(SignalInfo item, boolean fireUpdate) {
        int idx = this.info.indexOf(item);
        if (idx >= 0) {
            return this.signals.get(idx);
        }
        idx = this.info.size();
        this.info.add(item);
        Signal s = new Signal(idx, item, item.fetchValue(this.circuitState), 1L, this.timeEnd - 1L, this.historyLimit);
        this.signals.add(idx, s);
        item.setListener(this);
        if (fireUpdate) {
            this.fireSelectionChanged(null);
        }
        return s;
    }

    public void addModelListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(Listener l) {
        this.listeners.remove(l);
    }

    private void fireSignalsReset(Event e) {
        for (Listener l : this.listeners) {
            l.signalsReset(e);
        }
    }

    private void fireSignalsExtended(Event e) {
        for (Listener l : this.listeners) {
            l.signalsExtended(e);
        }
    }

    private void fireFilePropertyChanged(Event e) {
        for (Listener l : this.listeners) {
            l.filePropertyChanged(e);
        }
    }

    private void fireModeChanged(Event e) {
        for (Listener l : this.listeners) {
            l.modeChanged(e);
        }
    }

    private void fireHistoryLimitChanged(Event e) {
        for (Listener l : this.listeners) {
            l.historyLimitChanged(e);
        }
    }

    void fireSelectionChanged(Event e) {
        for (Listener l : this.listeners) {
            l.selectionChanged(e);
        }
    }

    public CircuitState getCircuitState() {
        return this.circuitState;
    }

    public Circuit getCircuit() {
        return this.circuitState == null ? null : this.circuitState.getCircuit();
    }

    public File getFile() {
        return this.file;
    }

    public boolean getFileHeader() {
        return this.fileHeader;
    }

    public int getSignalCount() {
        return this.signals.size();
    }

    public List<Signal> getSignals() {
        return this.signals;
    }

    public long getStartTime() {
        long t = 0L;
        for (Signal s : this.signals) {
            t = Math.max(t, s.omittedDataTime());
        }
        return t;
    }

    public long getEndTime() {
        return this.timeEnd;
    }

    public SignalInfo getItem(int idx) {
        return this.info.get(idx);
    }

    public Signal getSignal(int idx) {
        return this.signals.get(idx);
    }

    public Signal getSignal(SignalInfo item) {
        return this.signals.get(this.info.indexOf(item));
    }

    public int indexOf(SignalInfo item) {
        return this.info.indexOf(item);
    }

    public boolean isFileEnabled() {
        return this.fileEnabled;
    }

    public boolean isSelected() {
        return this.selected;
    }

    private void extendWithOldValues(long duration) {
        for (Signal s : this.signals) {
            Value v = s.info.fetchValue(this.circuitState);
            s.extend(duration);
        }
        this.elapsedSinceTrigger += duration;
        this.timeEnd += duration;
        this.fireSignalsExtended(null);
    }

    private void extendWithNewValues(long duration) {
        for (Signal s : this.signals) {
            Value v = s.info.fetchValue(this.circuitState);
            s.extend(v, duration);
        }
        this.elapsedSinceTrigger += duration;
        this.timeEnd += duration;
        this.fireSignalsExtended(null);
    }

    private void replaceWithNewValues(long duration) {
        for (Signal s : this.signals) {
            Value v = s.info.fetchValue(this.circuitState);
            s.replaceRecent(v, duration);
        }
        this.fireSignalsExtended(null);
    }

    public void propagationCompleted(boolean ticked, boolean stepped, boolean propagated) {
        if (!stepped && !propagated) {
            return;
        }
        if (this.isCoarse() && !propagated) {
            return;
        }
        if (this.mode == 10) {
            this.updateSignalsStepMode(propagated);
        } else if (this.mode == 20) {
            this.updateSignalsRealMode();
        } else if (this.mode >= 30) {
            this.updateSignalsClockMode();
        }
    }

    private void updateSignalsStepMode(boolean stable) {
        long duration = stable ? this.timeScale : this.gateDelay;
        this.extendWithNewValues(duration);
    }

    private void updateSignalsRealMode() {
        long now = System.nanoTime();
        double duration = (double)(now - this.lastRealtimeUpdate) * (double)this.timeScale / 1.0E9;
        this.extendWithNewValues(Math.max((long)duration, 1L));
        this.lastRealtimeUpdate = now;
    }

    private void updateSignalsClockMode() {
        Value v = this.clockSource.fetchValue(this.circuitState);
        ClockSource.CycleInfo cc = ClockSource.getCycleInfo(this.clockSource);
        if (this.mode == 60 && v.equals(HI) || this.mode == 70 && v.equals(LO)) {
            long activeDuration = (long)(this.mode == 60 ? cc.hi : cc.lo) * this.timeScale;
            long stableDuration = (long)(this.mode == 60 ? cc.lo : cc.hi) * this.timeScale;
            if (!v.equals(this.curClockVal)) {
                if (this.elapsedSinceTrigger < activeDuration) {
                    this.extendWithOldValues(stableDuration - this.elapsedSinceTrigger);
                }
                this.elapsedSinceTrigger = 0L;
                this.curClockVal = v;
            }
            long duration = this.gateDelay;
            this.extendWithNewValues(duration);
        } else if (this.mode == 60 || this.mode == 70) {
            long activeDuration = (long)(this.mode == 60 ? cc.hi : cc.lo) * this.timeScale;
            long stableDuration = (long)(this.mode == 60 ? cc.lo : cc.hi) * this.timeScale;
            if (!v.equals(this.curClockVal)) {
                if (this.elapsedSinceTrigger < activeDuration) {
                    this.extendWithOldValues(activeDuration - this.elapsedSinceTrigger);
                }
                this.elapsedSinceTrigger = 0L;
                this.curClockVal = v;
                long duration = this.isFine() ? this.gateDelay : stableDuration;
                this.extendWithNewValues(duration);
            } else if (this.isCoarse()) {
                this.replaceWithNewValues(stableDuration);
            } else {
                long duration = this.gateDelay;
                this.extendWithNewValues(duration);
            }
        } else {
            int ticks;
            int n = this.mode == 30 ? (v.equals(Value.FALSE) ? cc.lo : cc.hi) : (ticks = cc.ticks);
            int prevTicks = this.mode == 30 ? (v.equals(Value.FALSE) ? cc.hi : cc.lo) : cc.ticks;
            long stableDuration = this.timeScale * (long)ticks;
            long prevDuration = this.timeScale * (long)prevTicks;
            long duration = this.isFine() ? this.gateDelay : stableDuration;
            boolean triggered = this.mode == 30 && !v.equals(this.curClockVal) || this.mode == 40 && v.equals(HI) && !this.curClockVal.equals(HI) || this.mode == 50 && v.equals(LO) && !this.curClockVal.equals(LO);
            this.curClockVal = v;
            if (triggered) {
                if (this.isFine() && this.elapsedSinceTrigger < prevDuration) {
                    this.extendWithOldValues(prevDuration - this.elapsedSinceTrigger);
                }
                this.elapsedSinceTrigger = 0L;
                this.extendWithNewValues(duration);
            } else if (this.isCoarse()) {
                this.replaceWithNewValues(stableDuration);
            } else {
                this.extendWithNewValues(duration);
            }
        }
    }

    public void simulatorReset() {
        long duration;
        if (this.mode >= 30) {
            this.curClockVal = this.clockSource.fetchValue(this.circuitState);
            ClockSource.CycleInfo cc = ClockSource.getCycleInfo(this.clockSource);
            if (this.captureContinuous()) {
                duration = this.gateDelay;
            } else if (this.mode == 60 || this.mode == 70) {
                long activeDuration = (long)(this.mode == 60 ? cc.hi : cc.lo) * this.timeScale;
                long stableDuration = (long)(this.mode == 60 ? cc.lo : cc.hi) * this.timeScale;
                duration = this.isFine() ? this.gateDelay : stableDuration;
            } else {
                int ticks = this.mode == 30 ? (this.curClockVal.equals(Value.FALSE) ? cc.lo : cc.hi) : cc.ticks;
                long stableDuration = this.timeScale * (long)ticks;
                duration = this.isFine() ? this.gateDelay : stableDuration;
            }
        } else {
            duration = this.mode == 10 ? this.timeScale : this.gateDelay;
        }
        if (this.mode == 20) {
            this.lastRealtimeUpdate = System.nanoTime();
        }
        this.elapsedSinceTrigger = 0L;
        for (Signal s : this.signals) {
            Value v = s.info.fetchValue(this.circuitState);
            s.reset(v, duration);
        }
        this.elapsedSinceTrigger += duration;
        this.timeEnd = duration;
    }

    public void setFile(File value) {
        if (Objects.equals(this.file, value)) {
            return;
        }
        this.file = value;
        this.fileEnabled = this.file != null;
        this.fireFilePropertyChanged(null);
    }

    public void setFileEnabled(boolean value) {
        if (this.fileEnabled == value) {
            return;
        }
        this.fileEnabled = value;
        this.fireFilePropertyChanged(null);
    }

    public void setFileHeader(boolean value) {
        if (this.fileHeader == value) {
            return;
        }
        this.fileHeader = value;
        this.fireFilePropertyChanged(null);
    }

    public void setSelected(boolean value) {
        if (this.selected == value) {
            return;
        }
        this.selected = value;
        if (this.selected) {
            this.logger = new LogThread(this);
            this.logger.start();
        } else {
            if (this.logger != null) {
                this.logger.cancel();
            }
            this.logger = null;
            this.fileEnabled = false;
        }
        this.fireFilePropertyChanged(null);
    }

    public Signal getSpotlight() {
        return this.spotlight;
    }

    public Signal setSpotlight(Signal s) {
        Signal old = this.spotlight;
        this.spotlight = s;
        return old;
    }

    public SignalInfo getClockSourceInfo() {
        return this.clockSource;
    }

    public void setClockSourceInfo(SignalInfo item) {
        if (this.clockSource == item) {
            return;
        }
        this.clockSource = item;
        this.fireModeChanged(null);
    }

    public static String formatDuration(long t) {
        if (t < 1000L || t % 100L != 0L) {
            return Strings.S.get("nsFormat", String.format("%d", t));
        }
        if (t < 1000000L || t % 100000L != 0L) {
            return Strings.S.get("usFormat", String.format("%.1f", (double)t / 1000.0));
        }
        if (t < 100000000L || t % 100000000L != 0L) {
            return Strings.S.get("msFormat", String.format("%.1f", (double)t / 1000000.0));
        }
        return Strings.S.get("sFormat", String.format("%.1f", (double)t / 1.0E9));
    }

    public void setRadix(SignalInfo s, RadixOption value) {
        if (s.setRadix(value)) {
            this.fireSelectionChanged(null);
        }
    }

    public void checkForClocks() {
        Component clk = this.circuitState.getTemporaryClock();
        if (clk != null && (this.clockSource == null || this.clockSource.getComponent() != clk)) {
            if (this.clockSource != null && !this.info.contains(this.clockSource)) {
                this.clockSource.setListener(null);
            }
            this.clockSource = null;
            this.setStepMode(this.isFine(), this.timeScale, this.gateDelay);
            this.setClockMode(this.isFine(), 30, this.timeScale, this.gateDelay);
        }
    }

    public static class Event {
    }

    public static interface Listener {
        default public void signalsReset(Event event) {
        }

        default public void signalsExtended(Event event) {
        }

        default public void filePropertyChanged(Event event) {
        }

        default public void selectionChanged(Event event) {
        }

        default public void modeChanged(Event event) {
        }

        default public void historyLimitChanged(Event event) {
        }
    }
}

