/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.data.TestVector;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.log.LogPanel;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.util.JFileChoosers;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FilePanel
extends LogPanel {
    private static final long serialVersionUID = 1L;
    private final Listener listener = new Listener();
    private final JLabel enableLabel = new JLabel();
    private final JButton enableButton = new JButton();
    private final JLabel fileLabel = new JLabel();
    private final JTextField fileField = new JTextField();
    private final JButton selectButton = new JButton();
    private final JCheckBox headerCheckBox = new JCheckBox();
    private final JFileChooser chooser = JFileChoosers.create();

    public FilePanel(LogFrame frame) {
        super(frame);
        this.chooser.addChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.chooser.addChoosableFileFilter(TestVector.FILE_FILTER);
        this.chooser.setFileFilter(TestVector.FILE_FILTER);
        JPanel filePanel = new JPanel(new GridBagLayout());
        GridBagLayout gbl = (GridBagLayout)filePanel.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbl.setConstraints(this.fileLabel, gbc);
        filePanel.add(this.fileLabel);
        gbc.weightx = 1.0;
        gbl.setConstraints(this.fileField, gbc);
        filePanel.add(this.fileField);
        gbc.weightx = 0.0;
        gbl.setConstraints(this.selectButton, gbc);
        filePanel.add(this.selectButton);
        this.fileField.setEditable(false);
        this.fileField.setEnabled(false);
        this.setLayout(new GridBagLayout());
        gbl = (GridBagLayout)this.getLayout();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridy = -1;
        JPanel glue = new JPanel();
        gbc.weighty = 1.0;
        gbl.setConstraints(glue, gbc);
        this.add(glue);
        gbc.weighty = 0.0;
        gbl.setConstraints(this.enableLabel, gbc);
        this.add(this.enableLabel);
        gbl.setConstraints(this.enableButton, gbc);
        this.add(this.enableButton);
        glue = new JPanel();
        gbc.weighty = 1.0;
        gbl.setConstraints(glue, gbc);
        this.add(glue);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbl.setConstraints(filePanel, gbc);
        this.add(filePanel);
        gbc.fill = 0;
        glue = new JPanel();
        gbc.weighty = 1.0;
        gbl.setConstraints(glue, gbc);
        this.add(glue);
        gbc.weighty = 0.0;
        gbl.setConstraints(this.headerCheckBox, gbc);
        this.add(this.headerCheckBox);
        glue = new JPanel();
        gbc.weighty = 1.0;
        gbl.setConstraints(glue, gbc);
        this.add(glue);
        gbc.weighty = 0.0;
        this.enableButton.addActionListener(this.listener);
        this.selectButton.addActionListener(this.listener);
        this.headerCheckBox.addActionListener(this.listener);
        this.modelChanged(null, this.getModel());
        this.localeChanged();
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("fileHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("fileTab");
    }

    @Override
    public void localeChanged() {
        this.listener.computeEnableItems(this.getModel());
        this.fileLabel.setText(Strings.S.get("fileLabel") + " ");
        this.selectButton.setText(Strings.S.get("fileSelectButton"));
        this.headerCheckBox.setText(Strings.S.get("fileHeaderCheck"));
    }

    @Override
    public void modelChanged(Model oldModel, Model newModel) {
        if (oldModel != null) {
            oldModel.removeModelListener(this.listener);
        }
        if (newModel != null) {
            newModel.addModelListener(this.listener);
            this.listener.filePropertyChanged(null);
        }
    }

    private class Listener
    implements ActionListener,
    Model.Listener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == FilePanel.this.enableButton) {
                FilePanel.this.getModel().setFileEnabled(!FilePanel.this.getModel().isFileEnabled());
            } else if (src == FilePanel.this.selectButton) {
                int result = FilePanel.this.chooser.showSaveDialog(FilePanel.this.getLogFrame());
                if (result != 0) {
                    return;
                }
                File file = FilePanel.this.chooser.getSelectedFile();
                if (file.exists() && (!file.canWrite() || file.isDirectory())) {
                    OptionPane.showMessageDialog(FilePanel.this.getLogFrame(), Strings.S.get("fileCannotWriteMessage", file.getName()), Strings.S.get("fileCannotWriteTitle"), 0);
                    return;
                }
                if (file.exists() && file.length() > 0L) {
                    Object[] options = new String[]{Strings.S.get("fileOverwriteOption"), Strings.S.get("fileAppendOption"), Strings.S.get("fileCancelOption")};
                    int option = OptionPane.showOptionDialog(FilePanel.this.getLogFrame(), Strings.S.get("fileExistsMessage", file.getName()), Strings.S.get("fileExistsTitle"), 0, 3, null, options, options[0]);
                    if (option == 0) {
                        try {
                            FileWriter delete = new FileWriter(file);
                            delete.close();
                        }
                        catch (IOException iOException) {}
                    } else if (option != 1) {
                        return;
                    }
                }
                FilePanel.this.getModel().setFile(file);
            } else if (src == FilePanel.this.headerCheckBox) {
                FilePanel.this.getModel().setFileHeader(FilePanel.this.headerCheckBox.isSelected());
            }
        }

        private void computeEnableItems(Model model) {
            if (model.isFileEnabled()) {
                FilePanel.this.enableLabel.setText(Strings.S.get("fileEnabled"));
                FilePanel.this.enableButton.setText(Strings.S.get("fileDisableButton"));
            } else {
                FilePanel.this.enableLabel.setText(Strings.S.get("fileDisabled"));
                FilePanel.this.enableButton.setText(Strings.S.get("fileEnableButton"));
            }
        }

        @Override
        public void filePropertyChanged(Model.Event event) {
            Model model = FilePanel.this.getModel();
            this.computeEnableItems(model);
            File file = model.getFile();
            FilePanel.this.fileField.setText(file == null ? "" : file.getPath());
            FilePanel.this.enableButton.setEnabled(file != null);
            FilePanel.this.headerCheckBox.setSelected(model.getFileHeader());
        }
    }
}

