/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class ComboBox<T>
extends JComboBox<T> {
    private static final long serialVersionUID = 1L;

    public ComboBox(T[] choices) {
        super(choices);
        this.setMaximumRowCount(Math.min(choices.length, 33));
        this.setKeySelectionManager(new MultiCharSelectionManager());
    }

    public static class MultiCharSelectionManager
    implements JComboBox.KeySelectionManager {
        String prefix = "";
        long last;

        static int currentIndex(ComboBoxModel<?> model) {
            Object item = model.getSelectedItem();
            for (int i = 0; item != null && i < model.getSize(); ++i) {
                if (!item.equals(model.getElementAt(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int selectionForKey(char ch, ComboBoxModel<?> model) {
            int idx = MultiCharSelectionManager.currentIndex(model);
            long now = System.currentTimeMillis();
            if (now > this.last + 500L) {
                this.prefix = "";
                idx = 0;
            }
            this.last = now;
            this.prefix = this.prefix + Character.toLowerCase(ch);
            int n = model.getSize();
            for (int offset = 0; offset < n; ++offset) {
                int i = (idx + offset) % n;
                Object item = model.getElementAt(i);
                if (item == null || !item.toString().toLowerCase().startsWith(this.prefix)) continue;
                return i;
            }
            return -1;
        }
    }
}

