/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.canvas.Selection;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.util.ZOrder;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class SelectionAction
extends Action {
    private final StringGetter displayName;
    private final AppearanceCanvas canvas;
    private final CanvasModel canvasModel;
    private final Map<CanvasObject, Integer> toRemove;
    private final Collection<CanvasObject> toAdd;
    private final Collection<CanvasObject> oldSelection;
    private final Collection<CanvasObject> newSelection;
    private final Location anchorNewLocation;
    private final Direction anchorNewFacing;
    private Location anchorOldLocation;
    private Direction anchorOldFacing;

    public SelectionAction(AppearanceCanvas canvas, StringGetter displayName, Collection<CanvasObject> toRemove, Collection<CanvasObject> toAdd, Collection<CanvasObject> newSelection, Location anchorLocation, Direction anchorFacing) {
        this.canvas = canvas;
        this.canvasModel = canvas.getModel();
        this.displayName = displayName;
        this.toRemove = toRemove == null ? null : ZOrder.getZIndex(toRemove, this.canvasModel);
        this.toAdd = toAdd;
        this.oldSelection = new ArrayList<CanvasObject>(canvas.getSelection().getSelected());
        this.newSelection = newSelection;
        this.anchorNewLocation = anchorLocation;
        this.anchorNewFacing = anchorFacing;
    }

    @Override
    public void doIt(Project proj) {
        AppearanceAnchor anchor;
        Selection sel = this.canvas.getSelection();
        sel.clearSelected();
        if (this.toRemove != null) {
            this.canvasModel.removeObjects(this.toRemove.keySet());
        }
        int dest = AppearanceCanvas.getMaxIndex(this.canvasModel) + 1;
        if (this.toAdd != null) {
            this.canvasModel.addObjects(dest, this.toAdd);
        }
        if ((anchor = this.findAnchor(this.canvasModel)) != null && this.anchorNewLocation != null) {
            this.anchorOldLocation = anchor.getLocation();
            anchor.translate(this.anchorNewLocation.getX() - this.anchorOldLocation.getX(), this.anchorNewLocation.getY() - this.anchorOldLocation.getY());
        }
        if (anchor != null && this.anchorNewFacing != null) {
            this.anchorOldFacing = anchor.getFacingDirection();
            anchor.setValue(AppearanceAnchor.FACING, this.anchorNewFacing);
        }
        sel.setSelected(this.newSelection, true);
        this.canvas.repaint();
    }

    private AppearanceAnchor findAnchor(CanvasModel canvasModel) {
        for (CanvasObject obj : canvasModel.getObjectsFromTop()) {
            if (!(obj instanceof AppearanceAnchor)) continue;
            AppearanceAnchor anchor = (AppearanceAnchor)obj;
            return anchor;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.displayName.toString();
    }

    @Override
    public void undo(Project proj) {
        AppearanceAnchor anchor = this.findAnchor(this.canvasModel);
        if (anchor != null && this.anchorOldLocation != null) {
            anchor.translate(this.anchorOldLocation.getX() - this.anchorNewLocation.getX(), this.anchorOldLocation.getY() - this.anchorNewLocation.getY());
        }
        if (anchor != null && this.anchorOldFacing != null) {
            anchor.setValue(AppearanceAnchor.FACING, this.anchorOldFacing);
        }
        Selection sel = this.canvas.getSelection();
        sel.clearSelected();
        if (this.toAdd != null) {
            this.canvasModel.removeObjects(this.toAdd);
        }
        if (this.toRemove != null) {
            this.canvasModel.addObjects(this.toRemove);
        }
        sel.setSelected(this.oldSelection, true);
        this.canvas.repaint();
    }
}

