/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.scijava.swing.checkboxtree.CheckBoxNodeData;
import org.scijava.swing.checkboxtree.CheckBoxNodeEditor;
import org.scijava.swing.checkboxtree.CheckBoxNodeRenderer;

public class CheckBoxTree
extends JTree {
    public CheckBoxTree(DefaultMutableTreeNode root) {
        super(root);
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        this.setCellRenderer(renderer);
        this.setCellEditor(new CheckBoxNodeEditor(this));
        this.setEditable(true);
        this.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                CheckBoxTree.this.nodeModified(e.getTreePath(), e.getChildIndices());
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }
        });
    }

    private void nodeModified(TreePath parentPath, int[] changedChildren) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        if (changedChildren == null) {
            node = parent;
            parent = null;
        } else {
            node = (DefaultMutableTreeNode)parent.getChildAt(changedChildren[0]);
        }
        boolean checked = ((CheckBoxNodeData)node.getUserObject()).isChecked();
        this.markDescendents(node, checked);
        for (DefaultMutableTreeNode p = parent; p != null; p = (DefaultMutableTreeNode)p.getParent()) {
            this.adjustParentForChildrenValues(p);
        }
    }

    private void markDescendents(DefaultMutableTreeNode node, boolean checked) {
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            ((CheckBoxNodeData)n.getUserObject()).setChecked(checked);
        }
    }

    private void adjustParentForChildrenValues(DefaultMutableTreeNode parent) {
        boolean foundCheck = false;
        Enumeration<TreeNode> e = parent.children();
        while (!foundCheck && e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            foundCheck = ((CheckBoxNodeData)child.getUserObject()).isChecked();
        }
        ((CheckBoxNodeData)parent.getUserObject()).setChecked(foundCheck);
    }

    private void adjustParentsInTree(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.postorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.isLeaf()) continue;
            this.adjustParentForChildrenValues(node);
        }
    }

    public void setCheckingPaths(TreePath[] paths) {
        for (TreePath path : paths) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            ((CheckBoxNodeData)treeNode.getUserObject()).setChecked(true);
        }
        this.adjustParentsInTree((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    public TreePath[] getCheckingPaths() {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!((CheckBoxNodeData)n.getUserObject()).isChecked()) continue;
            paths.add(new TreePath(n.getPath()));
        }
        return paths.toArray(new TreePath[0]);
    }

    public boolean isPathChecked(TreePath path) {
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
        return ((CheckBoxNodeData)n.getUserObject()).isChecked();
    }
}

