/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MapListModel;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LocaleListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PartialMapDialog
extends JDialog
implements LocaleListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final MapListModel.MapInfo mapInfo;
    private final FpgaIoInformationContainer ioComp;
    private ArrayList<Integer> InputMapSet;
    private ArrayList<Integer> OutputMapSet;
    private ArrayList<Integer> IOMapSet;
    private JComboBox<String> InputSingleMultiple;
    private JComboBox<String> OutputSingleMultiple;
    private JComboBox<String> IOSingleMultiple;
    private JComboBox<String> InputMultipleSingle;
    private JComboBox<String> OutputMultipleSingle;
    private JComboBox<String> IOMultipleSingle;
    private ArrayList<JComboBox<String>> InputMultipleMultiple;
    private ArrayList<JComboBox<String>> OutputMultipleMultiple;
    private ArrayList<JComboBox<String>> IOMultipleMultiple;
    private final ArrayList<JLabel> MapTo;
    private final JButton OkButton;
    private final JButton CancelButton;
    private final String actionOk = "Ok";
    private final String actionCancel = "Cancel";

    public PartialMapDialog(MapListModel.MapInfo map, FpgaIoInformationContainer io, JPanel parent) {
        this.mapInfo = map;
        this.ioComp = io;
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setResizable(true);
        this.setLocationRelativeTo(parent);
        this.setAlwaysOnTop(true);
        this.MapTo = new ArrayList();
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        JPanel pane = this.createInputPane();
        if (pane != null) {
            content.add((Component)pane, "North");
        }
        if ((pane = this.createOutputPane()) != null) {
            content.add((Component)pane, "Center");
        }
        if ((pane = this.createIOPane()) != null) {
            content.add((Component)pane, "South");
        }
        JScrollPane scroll = new JScrollPane(content);
        scroll.setPreferredSize(new Dimension(AppPreferences.getScaled(450), AppPreferences.getScaled(250)));
        this.add((Component)scroll, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new BorderLayout());
        this.OkButton = new JButton();
        this.OkButton.setActionCommand("Ok");
        this.OkButton.addActionListener(this);
        buttonBar.add((Component)this.OkButton, "Center");
        this.CancelButton = new JButton();
        this.CancelButton.setActionCommand("Cancel");
        this.CancelButton.addActionListener(this);
        buttonBar.add((Component)this.CancelButton, "West");
        this.add((Component)buttonBar, "South");
    }

    public boolean doit() {
        this.localeChanged();
        this.setVisible(true);
        this.dispose();
        return true;
    }

    private JPanel createInputPane() {
        MapComponent map = this.mapInfo.getMap();
        if (!map.hasInputs()) {
            return null;
        }
        if (this.mapInfo.getPin() >= 0 && !map.isInput(this.mapInfo.getPin())) {
            return null;
        }
        if (this.InputMapSet == null) {
            this.InputMapSet = new ArrayList();
        }
        if (this.ioComp.hasInputs()) {
            this.InputMapSet.addAll(this.ioComp.getInputs());
        }
        if (this.ioComp.hasIoPins()) {
            this.InputMapSet.addAll(this.ioComp.getIos());
        }
        if (this.InputMapSet.isEmpty()) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("FpgaInputsMap")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = -1;
        if (map.nrInputs() == 1 || this.mapInfo.getPin() >= 0) {
            this.InputSingleMultiple = new JComboBox();
            this.InputSingleMultiple.addItem(Strings.S.get("FpgaNotMapped"));
            for (Integer integer : this.InputMapSet) {
                this.InputSingleMultiple.addItem(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(integer));
            }
            this.InputSingleMultiple.addActionListener(this);
            ++gbc.gridy;
            panel.add((Component)new JLabel(map.getDisplayString(this.mapInfo.getPin())), gbc);
            ++gbc.gridx;
            JLabel mapToAdd = new JLabel();
            this.MapTo.add(mapToAdd);
            panel.add((Component)mapToAdd, gbc);
            ++gbc.gridx;
            panel.add(this.InputSingleMultiple, gbc);
        } else if (this.InputMapSet.size() == 1) {
            this.InputMultipleSingle = new JComboBox();
            this.InputMultipleSingle.addItem(Strings.S.get("FpgaNotMapped"));
            for (int i = 0; i < map.nrInputs(); ++i) {
                this.InputMultipleSingle.addItem(map.getDisplayString(i));
            }
            this.InputMultipleSingle.addActionListener(this);
            ++gbc.gridy;
            panel.add(this.InputMultipleSingle, gbc);
            ++gbc.gridx;
            JLabel mapToAdd = new JLabel();
            this.MapTo.add(mapToAdd);
            panel.add((Component)mapToAdd, gbc);
            ++gbc.gridx;
            panel.add((Component)new JLabel(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(this.InputMapSet.get(0))), gbc);
        } else {
            this.InputMultipleMultiple = new ArrayList();
            for (int i = 0; i < map.nrInputs(); ++i) {
                JComboBox<Object> sels = new JComboBox<Object>();
                sels.addItem(Strings.S.get("FpgaNotMapped"));
                for (Integer integer : this.InputMapSet) {
                    sels.addItem(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(integer));
                }
                sels.addActionListener(this);
                this.InputMultipleMultiple.add(sels);
                gbc.gridx = 0;
                ++gbc.gridy;
                panel.add((Component)new JLabel(map.getDisplayString(i)), gbc);
                ++gbc.gridx;
                JLabel mapToAdd = new JLabel();
                this.MapTo.add(mapToAdd);
                panel.add((Component)mapToAdd, gbc);
                ++gbc.gridx;
                panel.add(sels, gbc);
            }
        }
        return panel;
    }

    private JPanel createOutputPane() {
        MapComponent map = this.mapInfo.getMap();
        if (!map.hasOutputs()) {
            return null;
        }
        if (this.mapInfo.getPin() >= 0 && !map.isOutput(this.mapInfo.getPin())) {
            return null;
        }
        if (this.OutputMapSet == null) {
            this.OutputMapSet = new ArrayList();
        }
        if (this.ioComp.hasOutputs()) {
            this.OutputMapSet.addAll(this.ioComp.getOutputs());
        }
        if (this.ioComp.hasIoPins()) {
            this.OutputMapSet.addAll(this.ioComp.getIos());
        }
        if (this.OutputMapSet.isEmpty()) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("FpgaOutputsMap")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = -1;
        if (map.nrOutputs() == 1 || this.mapInfo.getPin() >= 0) {
            this.OutputSingleMultiple = new JComboBox();
            this.OutputSingleMultiple.addItem(Strings.S.get("FpgaNotMapped"));
            for (Integer integer : this.OutputMapSet) {
                this.OutputSingleMultiple.addItem(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(integer));
            }
            this.OutputSingleMultiple.addActionListener(this);
            ++gbc.gridy;
            panel.add((Component)new JLabel(map.getDisplayString(this.mapInfo.getPin())), gbc);
            ++gbc.gridx;
            JLabel mapToAdd = new JLabel();
            this.MapTo.add(mapToAdd);
            panel.add((Component)mapToAdd, gbc);
            ++gbc.gridx;
            panel.add(this.OutputSingleMultiple, gbc);
        } else if (this.OutputMapSet.size() == 1) {
            this.OutputMultipleSingle = new JComboBox();
            this.OutputMultipleSingle.addItem(Strings.S.get("FpgaNotMapped"));
            for (int i = 0; i < map.nrOutputs(); ++i) {
                this.OutputMultipleSingle.addItem(map.getDisplayString(map.nrInputs() + i));
            }
            this.OutputMultipleSingle.addActionListener(this);
            ++gbc.gridy;
            panel.add(this.OutputMultipleSingle, gbc);
            ++gbc.gridx;
            JLabel mapToAdd = new JLabel();
            this.MapTo.add(mapToAdd);
            panel.add((Component)mapToAdd, gbc);
            ++gbc.gridx;
            panel.add((Component)new JLabel(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(this.OutputMapSet.get(0))), gbc);
        } else {
            this.OutputMultipleMultiple = new ArrayList();
            for (int i = 0; i < map.nrOutputs(); ++i) {
                JComboBox<Object> sels = new JComboBox<Object>();
                sels.addItem(Strings.S.get("FpgaNotMapped"));
                for (Integer integer : this.OutputMapSet) {
                    sels.addItem(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(integer));
                }
                sels.addActionListener(this);
                this.OutputMultipleMultiple.add(sels);
                gbc.gridx = 0;
                ++gbc.gridy;
                panel.add((Component)new JLabel(map.getDisplayString(map.nrInputs() + i)), gbc);
                ++gbc.gridx;
                JLabel mapToAdd = new JLabel();
                this.MapTo.add(mapToAdd);
                panel.add((Component)mapToAdd, gbc);
                ++gbc.gridx;
                panel.add(sels, gbc);
            }
        }
        return panel;
    }

    private JPanel createIOPane() {
        MapComponent map = this.mapInfo.getMap();
        if (!map.hasIos()) {
            return null;
        }
        if (this.mapInfo.getPin() >= 0 && !map.isIo(this.mapInfo.getPin())) {
            return null;
        }
        if (this.IOMapSet == null) {
            this.IOMapSet = new ArrayList();
        }
        if (this.ioComp.hasIoPins()) {
            this.IOMapSet.addAll(this.ioComp.getIos());
        }
        if (this.IOMapSet.isEmpty()) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Strings.S.get("FpgaIOsMap")));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = -1;
        if (map.nrIOs() == 1 || this.mapInfo.getPin() >= 0) {
            this.IOSingleMultiple = new JComboBox();
            this.IOSingleMultiple.addItem(Strings.S.get("FpgaNotMapped"));
            for (Integer integer : this.IOMapSet) {
                this.IOSingleMultiple.addItem(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(integer));
            }
            this.IOSingleMultiple.addActionListener(this);
            ++gbc.gridy;
            panel.add((Component)new JLabel(map.getDisplayString(this.mapInfo.getPin())), gbc);
            ++gbc.gridx;
            JLabel mapToAdd = new JLabel();
            this.MapTo.add(mapToAdd);
            panel.add((Component)mapToAdd, gbc);
            ++gbc.gridx;
            panel.add(this.IOSingleMultiple, gbc);
        } else if (this.IOMapSet.size() == 1) {
            this.IOMultipleSingle = new JComboBox();
            this.IOMultipleSingle.addItem(Strings.S.get("FpgaNotMapped"));
            for (int i = 0; i < map.nrIOs(); ++i) {
                this.IOMultipleSingle.addItem(map.getDisplayString(map.nrInputs() + map.nrOutputs() + i));
            }
            this.IOMultipleSingle.addActionListener(this);
            ++gbc.gridy;
            panel.add(this.IOMultipleSingle, gbc);
            ++gbc.gridx;
            JLabel mapToAdd = new JLabel();
            this.MapTo.add(mapToAdd);
            panel.add((Component)mapToAdd, gbc);
            ++gbc.gridx;
            panel.add((Component)new JLabel(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(this.IOMapSet.get(0))), gbc);
        } else {
            this.IOMultipleMultiple = new ArrayList();
            for (int i = 0; i < map.nrIOs(); ++i) {
                JComboBox<Object> sels = new JComboBox<Object>();
                sels.addItem(Strings.S.get("FpgaNotMapped"));
                for (Integer integer : this.IOMapSet) {
                    sels.addItem(this.ioComp.getDisplayString() + "/" + this.ioComp.getPinName(integer));
                }
                sels.addActionListener(this);
                this.IOMultipleMultiple.add(sels);
                gbc.gridx = 0;
                ++gbc.gridy;
                panel.add((Component)new JLabel(map.getDisplayString(map.nrInputs() + map.nrOutputs() + i)), gbc);
                ++gbc.gridx;
                JLabel mapToAdd = new JLabel();
                this.MapTo.add(mapToAdd);
                panel.add((Component)mapToAdd, gbc);
                ++gbc.gridx;
                panel.add(sels, gbc);
            }
        }
        return panel;
    }

    private void update(JComboBox<String> source) {
        Integer selId;
        Integer selId2;
        Integer selId3;
        Integer selId4;
        int i;
        if (source.getSelectedIndex() == 0) {
            return;
        }
        int pinid = -1;
        if (source.equals(this.InputSingleMultiple)) {
            pinid = this.InputMapSet.get(source.getSelectedIndex() - 1);
        }
        for (i = 0; this.InputMultipleMultiple != null && pinid < 0 && i < this.InputMultipleMultiple.size(); ++i) {
            if (!source.equals(this.InputMultipleMultiple.get(i))) continue;
            pinid = this.InputMapSet.get(this.InputMultipleMultiple.get(i).getSelectedIndex() - 1);
        }
        if (source.equals(this.OutputSingleMultiple)) {
            pinid = this.OutputMapSet.get(source.getSelectedIndex() - 1);
        }
        for (i = 0; this.OutputMultipleMultiple != null && pinid < 0 && i < this.OutputMultipleMultiple.size(); ++i) {
            if (!source.equals(this.OutputMultipleMultiple.get(i))) continue;
            pinid = this.OutputMapSet.get(this.OutputMultipleMultiple.get(i).getSelectedIndex() - 1);
        }
        if (source.equals(this.IOSingleMultiple)) {
            pinid = this.IOMapSet.get(source.getSelectedIndex() - 1);
        }
        for (i = 0; this.IOMultipleMultiple != null && pinid < 0 && i < this.IOMultipleMultiple.size(); ++i) {
            if (!source.equals(this.IOMultipleMultiple.get(i))) continue;
            pinid = this.IOMapSet.get(this.IOMultipleMultiple.get(i).getSelectedIndex() - 1);
        }
        if (this.InputSingleMultiple != null && !source.equals(this.InputSingleMultiple) && this.InputSingleMultiple.getSelectedIndex() != 0 && pinid == (selId4 = this.InputMapSet.get(this.InputSingleMultiple.getSelectedIndex() - 1))) {
            this.InputSingleMultiple.setSelectedIndex(0);
        }
        for (int i2 = 0; this.InputMultipleMultiple != null && i2 < this.InputMultipleMultiple.size(); ++i2) {
            if (source.equals(this.InputMultipleMultiple.get(i2)) || this.InputMultipleMultiple.get(i2).getSelectedIndex() == 0 || pinid != (selId3 = this.InputMapSet.get(this.InputMultipleMultiple.get(i2).getSelectedIndex() - 1))) continue;
            this.InputMultipleMultiple.get(i2).setSelectedIndex(0);
        }
        if (this.OutputSingleMultiple != null && !source.equals(this.OutputSingleMultiple) && this.OutputSingleMultiple.getSelectedIndex() != 0 && pinid == (selId2 = this.OutputMapSet.get(this.OutputSingleMultiple.getSelectedIndex() - 1))) {
            this.OutputSingleMultiple.setSelectedIndex(0);
        }
        for (int i3 = 0; this.OutputMultipleMultiple != null && i3 < this.OutputMultipleMultiple.size(); ++i3) {
            if (source.equals(this.OutputMultipleMultiple.get(i3)) || this.OutputMultipleMultiple.get(i3).getSelectedIndex() == 0 || pinid != (selId3 = this.OutputMapSet.get(this.OutputMultipleMultiple.get(i3).getSelectedIndex() - 1))) continue;
            this.OutputMultipleMultiple.get(i3).setSelectedIndex(0);
        }
        if (this.IOSingleMultiple != null && !source.equals(this.IOSingleMultiple) && this.IOSingleMultiple.getSelectedIndex() != 0 && pinid == (selId = this.IOMapSet.get(this.IOSingleMultiple.getSelectedIndex() - 1))) {
            this.IOSingleMultiple.setSelectedIndex(0);
        }
        for (int i4 = 0; this.IOMultipleMultiple != null && i4 < this.IOMultipleMultiple.size(); ++i4) {
            if (source.equals(this.IOMultipleMultiple.get(i4)) || this.IOMultipleMultiple.get(i4).getSelectedIndex() == 0 || pinid != (selId3 = this.IOMapSet.get(this.IOMultipleMultiple.get(i4).getSelectedIndex() - 1))) continue;
            this.IOMultipleMultiple.get(i4).setSelectedIndex(0);
        }
    }

    @Override
    public void localeChanged() {
        for (JLabel jLabel : this.MapTo) {
            jLabel.setText(Strings.S.get("FpgaMapTo"));
        }
        this.OkButton.setText(Strings.S.get("FpgaBoardDone"));
        this.CancelButton.setText(Strings.S.get("FpgaBoardCancel"));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.InputMultipleSingle)) {
            if (this.InputMultipleSingle.getSelectedIndex() != 0) {
                if (this.OutputMultipleSingle != null) {
                    this.OutputMultipleSingle.setSelectedIndex(0);
                }
                if (this.IOMultipleSingle != null) {
                    this.IOMultipleSingle.setSelectedIndex(0);
                }
            }
            return;
        }
        if (e.getSource().equals(this.OutputMultipleSingle)) {
            if (this.OutputMultipleSingle.getSelectedIndex() != 0) {
                if (this.InputMultipleSingle != null) {
                    this.InputMultipleSingle.setSelectedIndex(0);
                }
                if (this.IOMultipleSingle != null) {
                    this.IOMultipleSingle.setSelectedIndex(0);
                }
            }
            return;
        }
        if (e.getSource().equals(this.IOMultipleSingle)) {
            if (this.IOMultipleSingle.getSelectedIndex() != 0) {
                if (this.InputMultipleSingle != null) {
                    this.InputMultipleSingle.setSelectedIndex(0);
                }
                if (this.OutputMultipleSingle != null) {
                    this.OutputMultipleSingle.setSelectedIndex(0);
                }
            }
            return;
        }
        Object object = e.getSource();
        if (object instanceof JComboBox) {
            JComboBox box = (JComboBox)object;
            this.update(box);
            return;
        }
        if (e.getActionCommand().equals("Ok")) {
            int pin;
            Integer pinId;
            int i;
            MapComponent map = this.mapInfo.getMap();
            if (this.InputSingleMultiple != null && this.InputSingleMultiple.getSelectedIndex() != 0) {
                int pin2 = Math.max(this.mapInfo.getPin(), 0);
                map.unmap(pin2);
                map.tryMap(pin2, this.ioComp, this.InputMapSet.get(this.InputSingleMultiple.getSelectedIndex() - 1));
            }
            if (this.InputMultipleSingle != null && this.InputMultipleSingle.getSelectedIndex() != 0) {
                map.unmap(this.InputMultipleSingle.getSelectedIndex() - 1);
                map.tryMap(this.InputMultipleSingle.getSelectedIndex() - 1, this.ioComp, this.InputMapSet.get(0));
            }
            for (i = 0; this.InputMultipleMultiple != null && i < this.InputMultipleMultiple.size(); ++i) {
                if (this.InputMultipleMultiple.get(i).getSelectedIndex() == 0) continue;
                pinId = this.InputMapSet.get(this.InputMultipleMultiple.get(i).getSelectedIndex() - 1);
                map.unmap(i);
                map.tryMap(i, this.ioComp, pinId);
            }
            if (this.OutputSingleMultiple != null && this.OutputSingleMultiple.getSelectedIndex() != 0) {
                pin = this.mapInfo.getPin() < 0 ? map.nrInputs() : this.mapInfo.getPin();
                map.unmap(pin);
                map.tryMap(pin, this.ioComp, this.OutputMapSet.get(this.OutputSingleMultiple.getSelectedIndex() - 1));
            }
            if (this.OutputMultipleSingle != null && this.OutputMultipleSingle.getSelectedIndex() != 0) {
                pin = map.nrInputs() + this.OutputMultipleSingle.getSelectedIndex() - 1;
                map.unmap(pin);
                map.tryMap(pin, this.ioComp, this.OutputMapSet.get(0));
            }
            for (i = 0; this.OutputMultipleMultiple != null && i < this.OutputMultipleMultiple.size(); ++i) {
                if (this.OutputMultipleMultiple.get(i).getSelectedIndex() == 0) continue;
                pinId = this.OutputMapSet.get(this.OutputMultipleMultiple.get(i).getSelectedIndex() - 1);
                map.unmap(map.nrInputs() + i);
                map.tryMap(map.nrInputs() + i, this.ioComp, pinId);
            }
            if (this.IOSingleMultiple != null && this.IOSingleMultiple.getSelectedIndex() != 0) {
                pin = this.mapInfo.getPin() < 0 ? map.nrInputs() + map.nrOutputs() : this.mapInfo.getPin();
                map.unmap(pin);
                map.tryMap(pin, this.ioComp, this.IOMapSet.get(this.IOSingleMultiple.getSelectedIndex() - 1));
            }
            if (this.IOMultipleSingle != null && this.IOMultipleSingle.getSelectedIndex() != 0) {
                pin = map.nrInputs() + map.nrOutputs() + this.IOMultipleSingle.getSelectedIndex() - 1;
                map.unmap(pin);
                map.tryMap(pin, this.ioComp, this.IOMapSet.get(0));
            }
            for (i = 0; this.IOMultipleMultiple != null && i < this.IOMultipleMultiple.size(); ++i) {
                if (this.IOMultipleMultiple.get(i).getSelectedIndex() == 0) continue;
                pinId = this.IOMapSet.get(this.IOMultipleMultiple.get(i).getSelectedIndex() - 1);
                int pin3 = map.nrInputs() + map.nrOutputs() + i;
                map.unmap(pin3);
                map.tryMap(pin3, this.ioComp, pinId);
            }
        }
        this.setVisible(false);
    }
}

