/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.BoardManipulatorListener;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.ConstantButton;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentTypes;
import com.cburch.logisim.fpga.data.IoComponentsInformation;
import com.cburch.logisim.fpga.data.IoComponentsListener;
import com.cburch.logisim.fpga.data.MapListModel;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.data.SimpleRectangle;
import com.cburch.logisim.fpga.file.PngFileFilter;
import com.cburch.logisim.fpga.gui.BoardPainter;
import com.cburch.logisim.fpga.gui.DialogNotification;
import com.cburch.logisim.fpga.gui.IoComponentSelector;
import com.cburch.logisim.fpga.gui.ZoomSlider;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LocaleListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BoardManipulator
extends JPanel
implements BaseMouseListenerContract,
BaseMouseMotionListenerContract,
ChangeListener,
PropertyChangeListener,
IoComponentsListener,
ListSelectionListener,
BaseWindowListenerContract,
LocaleListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int IMAGE_WIDTH = 740;
    public static final int IMAGE_HEIGHT = 400;
    public static final int CONSTANT_BAR_HEIGHT = 30;
    public static final int CONSTANT_BUTTON_WIDTH = 185;
    public static final int TRANSPARENT_ID = 0;
    public static final int DEFINE_COLOR_ID = 1;
    public static final int HIGHLIGHT_COLOR_ID = 2;
    public static final int MOVE_COLOR_ID = 3;
    public static final int RESIZE_COLOR_ID = 4;
    public static final int MAPPED_COLOR_ID = 5;
    public static final int SELECTED_MAPPED_COLOR_ID = 6;
    public static final int SELECTABLE_MAPPED_COLOR_ID = 7;
    public static final int SELECTABLE_COLOR_ID = 8;
    public static Color defineColor = new Color(AppPreferences.FPGA_DEFINE_COLOR.get());
    public static Color highlightColor = new Color(AppPreferences.FPGA_DEFINE_HIGHLIGHT_COLOR.get());
    public static Color moveColor = new Color(AppPreferences.FPGA_DEFINE_MOVE_COLOR.get());
    public static Color resizeColor = new Color(AppPreferences.FPGA_DEFINE_RESIZE_COLOR.get());
    public static Color mappedColor = new Color(AppPreferences.FPGA_MAPPED_COLOR.get());
    public static Color selectedMapColor = new Color(AppPreferences.FPGA_SELECTED_MAPPED_COLOR.get());
    public static Color selectableMapColor = new Color(AppPreferences.FPGA_SELECTABLE_MAPPED_COLOR.get());
    public static Color selectableColor = new Color(AppPreferences.FPGA_SELECT_COLOR.get());
    private ZoomSlider zoom;
    private int maxZoom;
    private float scale;
    private BufferedImage image;
    private final boolean mapMode;
    private String boardName;
    private SimpleRectangle defineRectangle;
    private ArrayList<BoardManipulatorListener> listeners;
    private final IoComponentsInformation ioComps;
    private MappableResourcesContainer mapInfo;
    private JList<MapListModel.MapInfo> unmappedList;
    private JList<MapListModel.MapInfo> mappedList;
    private JButton unmapButton;
    private JButton unmapAllButton;

    public BoardManipulator(Frame parentFrame) {
        this.mapMode = false;
        this.ioComps = new IoComponentsInformation(parentFrame, false);
        this.ioComps.addListener(this);
        this.setup(false);
    }

    public BoardManipulator(JDialog manip, Frame parentFrame, MappableResourcesContainer mapInfo) {
        this.mapMode = true;
        this.setup(true);
        this.ioComps = mapInfo.getIoComponentInformation();
        this.ioComps.addListener(this);
        this.ioComps.addComponent(ConstantButton.ONE_BUTTON, 1.0f);
        this.ioComps.addComponent(ConstantButton.OPEN_BUTTON, 1.0f);
        this.ioComps.addComponent(ConstantButton.VALUE_BUTTON, 1.0f);
        this.ioComps.addComponent(ConstantButton.ZERO_BUTTON, 1.0f);
        this.image = mapInfo.getBoardInformation().getImage();
        this.ioComps.setParentFrame(parentFrame);
        this.mapInfo = mapInfo;
        manip.addWindowListener(this);
    }

    private void setup(boolean MapMode) {
        this.zoom = new ZoomSlider();
        this.zoom.addChangeListener(this);
        this.maxZoom = this.zoom.getMaxZoom();
        this.scale = 1.0f;
        this.image = null;
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.defineRectangle = null;
        AppPreferences.FPGA_DEFINE_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_DEFINE_HIGHLIGHT_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_DEFINE_MOVE_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_DEFINE_RESIZE_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_MAPPED_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_SELECTED_MAPPED_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_SELECTABLE_MAPPED_COLOR.addPropertyChangeListener(this);
        AppPreferences.FPGA_SELECT_COLOR.addPropertyChangeListener(this);
    }

    public JList<MapListModel.MapInfo> getUnmappedList() {
        if (this.mapInfo == null) {
            return null;
        }
        this.unmappedList = new JList();
        this.unmappedList.setModel(new MapListModel(false, this.mapInfo.getMappableResources()));
        this.unmappedList.setSelectionMode(0);
        this.unmappedList.addListSelectionListener(this);
        return this.unmappedList;
    }

    public JList<MapListModel.MapInfo> getMappedList() {
        if (this.mapInfo == null) {
            return null;
        }
        this.mappedList = new JList();
        this.mappedList.setModel(new MapListModel(true, this.mapInfo.getMappableResources()));
        this.mappedList.setSelectionMode(0);
        this.mappedList.addListSelectionListener(this);
        return this.mappedList;
    }

    public void cleanup() {
        if (this.mapInfo != null) {
            this.mapInfo.destroyIOComponentInformation();
            this.mapInfo = null;
        }
        if (this.unmappedList != null) {
            this.unmappedList = null;
        }
        if (this.mappedList != null) {
            this.mappedList = null;
        }
        if (this.unmapButton != null) {
            this.unmapButton = null;
        }
        if (this.unmapAllButton != null) {
            this.unmapAllButton = null;
        }
    }

    public ZoomSlider getZoomSlider() {
        return this.zoom;
    }

    @Override
    public int getWidth() {
        return AppPreferences.getScaled(740, this.scale);
    }

    public void update() {
        if (this.unmappedList != null) {
            ((MapListModel)this.unmappedList.getModel()).rebuild();
            this.unmappedList.clearSelection();
        }
        if (this.mappedList != null) {
            ((MapListModel)this.mappedList.getModel()).rebuild();
            this.mappedList.clearSelection();
        }
        if (this.unmapButton != null) {
            this.unmapButton.setEnabled(false);
        }
        if (this.unmapAllButton != null) {
            this.unmapAllButton.setEnabled(false);
        }
    }

    @Override
    public int getHeight() {
        return AppPreferences.getScaled(400 + (this.mapMode ? 30 : 0), this.scale);
    }

    public JButton getUnmapOneButton() {
        if (this.unmapButton == null) {
            this.unmapButton = new JButton();
        }
        this.unmapButton.setEnabled(false);
        this.unmapButton.setActionCommand("unmapone");
        this.unmapButton.addActionListener(this);
        this.localeChanged();
        return this.unmapButton;
    }

    public JButton getUnmapAllButton() {
        if (this.unmapAllButton == null) {
            this.unmapAllButton = new JButton();
        }
        this.unmapAllButton.setActionCommand("unmapall");
        this.unmapAllButton.addActionListener(this);
        this.unmapAllButton.setEnabled(false);
        this.localeChanged();
        return this.unmapAllButton;
    }

    private int getPictureHeight() {
        return AppPreferences.getScaled(400, this.scale);
    }

    public boolean hasIOComponents() {
        return this.ioComps.hasComponents();
    }

    public static Color getColor(int id) {
        return switch (id) {
            case 1 -> defineColor;
            case 2 -> highlightColor;
            case 3 -> moveColor;
            case 4 -> resizeColor;
            case 5 -> mappedColor;
            case 6 -> selectedMapColor;
            case 7 -> selectableMapColor;
            case 8 -> selectableColor;
            default -> null;
        };
    }

    public Image getImage() {
        return this.image.getWidth() == 740 && this.image.getHeight() == 400 ? this.image : this.image.getScaledInstance(740, 400, 4);
    }

    public List<FpgaIoInformationContainer> getIoComponents() {
        return this.ioComps.getComponents();
    }

    public void addBoardManipulatorListener(BoardManipulatorListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            this.listeners.add(l);
        } else if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void setBoard(BoardInformation board) {
        this.clear();
        this.image = board.getImage();
        this.boardName = board.getBoardName();
        for (FpgaIoInformationContainer comp : board.getAllComponents()) {
            this.ioComps.addComponent(comp, this.scale);
        }
        for (BoardManipulatorListener listener : this.listeners) {
            listener.boardNameChanged(this.boardName);
        }
    }

    public void clear() {
        this.image = null;
        this.ioComps.clear();
        this.defineRectangle = null;
    }

    public void removeBoardManipulatorListener(BoardManipulatorListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void setMaxZoom(int value) {
        this.maxZoom = value < this.zoom.getMinZoom() ? this.zoom.getMinZoom() : Math.min(value, this.zoom.getMaxZoom());
    }

    private void defineIOComponent() {
        BoardRectangle rect = this.defineRectangle.getBoardRectangle(this.scale);
        FpgaIoInformationContainer comp = this.defineRectangle.getIoInfo();
        if (this.ioComps.hasOverlap(rect)) {
            DialogNotification.showDialogNotification(this.ioComps.getParentFrame(), "Error", Strings.S.get("FpgaBoardOverlap"));
            if (comp != null) {
                this.ioComps.addComponent(comp, this.scale);
            }
            return;
        }
        if (comp == null) {
            String result = new IoComponentSelector(this.ioComps.getParentFrame()).run();
            if (result == null) {
                return;
            }
            comp = new FpgaIoInformationContainer(IoComponentTypes.valueOf(result), rect, this.ioComps);
        } else {
            comp.getRectangle().updateRectangle(rect);
        }
        if (comp.isKnownComponent()) {
            this.ioComps.addComponent(comp, this.scale);
            for (BoardManipulatorListener listener : this.listeners) {
                listener.componentsChanged(this.ioComps);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (!this.mapMode && this.image == null) {
            BoardPainter.newBoardpainter(this, g2);
        } else if (this.image == null) {
            BoardPainter.errorBoardPainter(this, g2);
        } else {
            g2.drawImage(this.image.getScaledInstance(this.getWidth(), this.getPictureHeight(), 4), 0, 0, null);
            if (this.mapMode) {
                BoardPainter.paintConstantOpenBar(g2, this.scale);
            }
            this.ioComps.paint(g2, this.scale);
            if (!this.mapMode && this.defineRectangle != null) {
                this.defineRectangle.paint(g2);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        JSlider source = (JSlider)event.getSource();
        if (!source.getValueIsAdjusting()) {
            int value = source.getValue();
            if (value > this.maxZoom) {
                source.setValue(this.maxZoom);
                value = this.maxZoom;
            }
            this.scale = (float)value / 100.0f;
            Dimension mySize = new Dimension(this.getWidth(), this.getHeight());
            this.setPreferredSize(mySize);
            this.setSize(mySize);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mapMode) {
            return;
        }
        if (this.defineRectangle != null) {
            this.repaint(this.defineRectangle.resizeAndGetUpdate(e));
        } else if (this.ioComps.hasHighlighted()) {
            FpgaIoInformationContainer edit = this.ioComps.getHighligted();
            this.ioComps.removeComponent(edit, this.scale);
            this.defineRectangle = new SimpleRectangle(e, edit, this.scale);
            this.repaint(this.defineRectangle.resizeAndGetUpdate(e));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.ioComps.mouseMoved(e, this.scale);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mapMode && this.image == null) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(2);
            fc.setDialogTitle(Strings.S.get("BoardManipLoadPng"));
            fc.setFileFilter(PngFileFilter.PNG_FILTER);
            fc.setAcceptAllFileFilterUsed(false);
            int retVal = fc.showOpenDialog(this);
            if (retVal == 0) {
                File file = fc.getSelectedFile();
                try {
                    this.image = ImageIO.read(file);
                    this.repaint();
                    this.boardName = file.getName().toUpperCase().replaceAll(".PNG", "").replaceAll(".XML", "");
                    for (BoardManipulatorListener l : this.listeners) {
                        l.boardNameChanged(this.boardName);
                    }
                }
                catch (IOException ex) {
                    this.image = null;
                    OptionPane.showMessageDialog(this, Strings.S.get("BoardManipLoadError", file.getName()), Strings.S.get("BoardManipLoad"), 0);
                }
            }
        } else if (this.mapMode && this.ioComps.tryMap(this)) {
            int sel;
            this.repaint();
            this.update();
            for (sel = this.unmappedList.getSelectedIndex(); sel > this.unmappedList.getModel().getSize(); --sel) {
            }
            if (sel >= 0) {
                this.unmappedList.setSelectedIndex(sel);
            }
            this.mapInfo.markChanged();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mapMode) {
            return;
        }
        if (this.image != null) {
            if (this.ioComps.hasHighlighted()) {
                if (e.getClickCount() > 1) {
                    try {
                        FpgaIoInformationContainer clone = (FpgaIoInformationContainer)this.ioComps.getHighligted().clone();
                        clone.edit(true, this.ioComps);
                        if (clone.isToBeDeleted()) {
                            this.ioComps.removeComponent(this.ioComps.getHighligted(), this.scale);
                        } else if (clone.isKnownComponent()) {
                            this.ioComps.replaceComponent(this.ioComps.getHighligted(), clone, e, this.scale);
                        }
                    }
                    catch (CloneNotSupportedException err) {
                        OptionPane.showMessageDialog(this.ioComps.getParentFrame(), "INTERNAL BUG: Unable to clone!", "FATAL!", 0);
                    }
                }
            } else {
                this.defineRectangle = new SimpleRectangle(e);
                this.repaint(e.getX(), e.getY(), 1, 1);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.defineRectangle != null && !this.mapMode) {
            Rectangle toBeRepainted = this.defineRectangle.resizeRemoveAndgetUpdate(e);
            this.defineIOComponent();
            this.defineRectangle = null;
            this.repaint(toBeRepainted);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.ioComps.mouseExited(this.scale);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        defineColor = new Color(AppPreferences.FPGA_DEFINE_COLOR.get());
        highlightColor = new Color(AppPreferences.FPGA_DEFINE_HIGHLIGHT_COLOR.get());
        moveColor = new Color(AppPreferences.FPGA_DEFINE_MOVE_COLOR.get());
        resizeColor = new Color(AppPreferences.FPGA_DEFINE_RESIZE_COLOR.get());
        mappedColor = new Color(AppPreferences.FPGA_MAPPED_COLOR.get());
        selectedMapColor = new Color(AppPreferences.FPGA_SELECTED_MAPPED_COLOR.get());
        selectableMapColor = new Color(AppPreferences.FPGA_SELECTABLE_MAPPED_COLOR.get());
        selectableColor = new Color(AppPreferences.FPGA_SELECT_COLOR.get());
        this.repaint();
    }

    @Override
    public void repaintRequest(Rectangle rect) {
        this.repaint(rect);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.unmappedList)) {
            if (this.unmappedList.getSelectedIndex() >= 0) {
                this.mappedList.clearSelection();
                if (this.unmapButton != null) {
                    this.unmapButton.setEnabled(false);
                }
                this.ioComps.setSelectable(this.unmappedList.getSelectedValue(), this.scale);
            } else {
                this.ioComps.removeSelectable(this.scale);
            }
        } else if (event.getSource().equals(this.mappedList)) {
            if (this.mappedList.getSelectedIndex() >= 0) {
                this.unmappedList.clearSelection();
                if (this.unmapButton != null) {
                    this.unmapButton.setEnabled(true);
                }
                this.ioComps.setSelectable(this.mappedList.getSelectedValue(), this.scale);
            } else {
                this.ioComps.removeSelectable(this.scale);
            }
            if (this.mappedList.getModel().getSize() > 0) {
                if (this.unmapAllButton != null) {
                    this.unmapAllButton.setEnabled(true);
                }
            } else if (this.unmapAllButton != null) {
                this.unmapAllButton.setEnabled(false);
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
        this.ioComps.removeSelectable(this.scale);
        if (this.unmapButton != null) {
            this.unmapButton.setEnabled(false);
        }
    }

    @Override
    public void localeChanged() {
        if (this.unmapButton != null) {
            this.unmapButton.setText(Strings.S.get("BoardMapRelease"));
        }
        if (this.unmapAllButton != null) {
            this.unmapAllButton.setText(Strings.S.get("BoardMapRelAll"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("unmapone")) {
            if (this.mappedList.getSelectedIndex() >= 0) {
                MapListModel.MapInfo map = this.mappedList.getSelectedValue();
                if (map.getPin() < 0) {
                    map.getMap().unmap();
                } else {
                    map.getMap().unmap(map.getPin());
                }
                this.ioComps.removeSelectable(this.scale);
                this.update();
                this.mapInfo.markChanged();
            }
        } else if (event.getActionCommand().contentEquals("unmapall")) {
            this.ioComps.removeSelectable(this.scale);
            this.mapInfo.unMapAll();
            this.update();
            this.repaint();
            this.mapInfo.markChanged();
        }
    }
}

