/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMapInfo;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.FpgaIoInformationContainer;
import com.cburch.logisim.fpga.data.IoComponentsInformation;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.proj.ProjectActions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MappableResourcesContainer {
    private final Circuit myCircuit;
    private final BoardInformation currentUsedBoard;
    private IoComponentsInformation ioComps;
    private Map<ArrayList<String>, MapComponent> myMappableResources;
    private final List<FpgaIoInformationContainer> myIOComponents;

    public MappableResourcesContainer(BoardInformation CurrentBoard, Circuit circ) {
        this.currentUsedBoard = CurrentBoard;
        this.myCircuit = circ;
        ArrayList<String> BoardId = new ArrayList<String>();
        BoardId.add(CurrentBoard.getBoardName());
        this.myIOComponents = new ArrayList<FpgaIoInformationContainer>();
        for (FpgaIoInformationContainer io : this.currentUsedBoard.getAllComponents()) {
            try {
                FpgaIoInformationContainer clone = (FpgaIoInformationContainer)io.clone();
                clone.setMapMode();
                this.myIOComponents.add(clone);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        this.updateMapableComponents();
        circ.setBoardMap(CurrentBoard.getBoardName(), this);
    }

    public IoComponentsInformation getIoComponentInformation() {
        if (this.ioComps == null) {
            this.ioComps = new IoComponentsInformation(null, true);
            for (FpgaIoInformationContainer io : this.myIOComponents) {
                this.ioComps.addComponent(io, 1.0f);
            }
        }
        return this.ioComps;
    }

    public Map<ArrayList<String>, MapComponent> getMappableResources() {
        return this.myMappableResources;
    }

    public void destroyIOComponentInformation() {
        this.ioComps.clear();
        this.ioComps = null;
    }

    public String getToplevelName() {
        return this.myCircuit.getName();
    }

    public BoardInformation getBoardInformation() {
        return this.currentUsedBoard;
    }

    public void save() {
        ProjectActions.doSave(this.myCircuit.getProject());
    }

    public void updateMapableComponents() {
        HashSet<ArrayList<String>> cur = new HashSet<ArrayList<String>>();
        if (this.myMappableResources == null) {
            this.myMappableResources = new HashMap<ArrayList<String>, MapComponent>();
        } else {
            cur.addAll(this.myMappableResources.keySet());
        }
        ArrayList<String> BoardId = new ArrayList<String>();
        BoardId.add(this.currentUsedBoard.getBoardName());
        Map<ArrayList<String>, netlistComponent> newMappableResources = this.myCircuit.getNetList().getMappableResources(BoardId, true);
        for (ArrayList<String> key : newMappableResources.keySet()) {
            if (cur.contains(key)) {
                MapComponent comp = this.myMappableResources.get(key);
                if (!comp.equalsType(newMappableResources.get(key))) {
                    comp.unmap();
                    this.myMappableResources.put(key, new MapComponent(key, newMappableResources.get(key)));
                } else {
                    MapComponent newMap = new MapComponent(key, newMappableResources.get(key));
                    newMap.copyMapFrom(comp);
                    this.myMappableResources.put(key, newMap);
                }
                cur.remove(key);
                continue;
            }
            this.myMappableResources.put(key, new MapComponent(key, newMappableResources.get(key)));
        }
        for (ArrayList<String> key : cur) {
            this.myMappableResources.get(key).unmap();
            this.myMappableResources.remove(key);
        }
    }

    public void tryMap(String mapKey, CircuitMapInfo cmap) {
        ArrayList<String> key = this.getHierarchyName(mapKey);
        if (!this.myMappableResources.containsKey(key)) {
            return;
        }
        if (mapKey.contains("#")) {
            this.myMappableResources.get(key).tryMap(mapKey, cmap, this.myIOComponents);
        } else {
            this.myMappableResources.get(key).tryMap(cmap, this.myIOComponents);
        }
    }

    public void tryMap(String mapKey, BoardRectangle rect) {
        this.tryMap(mapKey, new CircuitMapInfo(rect));
    }

    public Map<String, CircuitMapInfo> getCircuitMap() {
        int id = 0;
        HashMap<String, CircuitMapInfo> result = new HashMap<String, CircuitMapInfo>();
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            result.put(Integer.toString(id++), new CircuitMapInfo(this.myMappableResources.get(key)));
        }
        return result;
    }

    public void unMapAll() {
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            this.myMappableResources.get(key).unmap();
        }
    }

    private ArrayList<String> getHierarchyName(String mapKey) {
        String[] split1 = mapKey.split(" ");
        String hier = split1[split1.length - 1];
        String[] split2 = hier.split("#");
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.currentUsedBoard.getBoardName());
        for (String key : split2[0].split("/")) {
            if (key.isEmpty()) continue;
            result.add(key);
        }
        return result;
    }

    public void markChanged() {
        this.myCircuit.getProject().setForcedDirty();
    }

    public boolean isCompletelyMapped() {
        boolean result = true;
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            MapComponent map = this.myMappableResources.get(key);
            for (int i = 0; i < map.getNrOfPins(); ++i) {
                result &= map.isMapped(i);
            }
        }
        return result;
    }

    public List<String> getMappedIoPinNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            MapComponent map = this.myMappableResources.get(key);
            for (int i = 0; i < map.getNrOfPins(); ++i) {
                if (!map.isIo(i) || map.isInternalMapped(i) || !map.isBoardMapped(i)) continue;
                StringBuilder sb = new StringBuilder();
                if (map.isExternalInverted(i)) {
                    sb.append("n_");
                }
                sb.append(map.getHdlString(i));
                result.add(sb.toString());
            }
        }
        return result;
    }

    public List<String> getMappedInputPinNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            MapComponent map = this.myMappableResources.get(key);
            for (int i = 0; i < map.getNrOfPins(); ++i) {
                if (!map.isInput(i) || map.isInternalMapped(i) || !map.isBoardMapped(i)) continue;
                StringBuilder sb = new StringBuilder();
                if (map.isExternalInverted(i)) {
                    sb.append("n_");
                }
                sb.append(map.getHdlString(i));
                result.add(sb.toString());
            }
        }
        return result;
    }

    public List<String> getMappedOutputPinNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ArrayList<String> key : this.myMappableResources.keySet()) {
            MapComponent map = this.myMappableResources.get(key);
            for (int i = 0; i < map.getNrOfPins(); ++i) {
                if (!map.isOutput(i) || map.isInternalMapped(i) || !map.isBoardMapped(i)) continue;
                StringBuilder sb = new StringBuilder();
                if (map.isExternalInverted(i)) {
                    sb.append("n_");
                }
                sb.append(map.getHdlString(i));
                result.add(sb.toString());
            }
        }
        return result;
    }
}

