/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import java.awt.Color;
import java.awt.Graphics;

class WireFactory
extends AbstractComponentFactory {
    public static final WireFactory instance = new WireFactory();

    private WireFactory() {
    }

    @Override
    public AttributeSet createAttributeSet() {
        return Wire.create(Location.create(0, 0, true), Location.create(100, 0, true));
    }

    @Override
    public Component createComponent(Location loc, AttributeSet attrs) {
        AttributeOption dir = attrs.getValue(Wire.DIR_ATTR);
        Integer len = attrs.getValue(Wire.LEN_ATTR);
        return dir == Wire.VALUE_HORZ ? Wire.create(loc, loc.translate(len, 0)) : Wire.create(loc, loc.translate(0, (int)len));
    }

    @Override
    public void drawGhost(ComponentDrawContext context, Color color, int x, int y, AttributeSet attrs) {
        Graphics g = context.getGraphics();
        AttributeOption dir = attrs.getValue(Wire.DIR_ATTR);
        Integer len = attrs.getValue(Wire.LEN_ATTR);
        g.setColor(color);
        GraphicsUtil.switchToWidth(g, 3);
        if (dir == Wire.VALUE_HORZ) {
            g.drawLine(x, y, x + len, y);
        } else {
            g.drawLine(x, y, x, y + len);
        }
    }

    @Override
    public StringGetter getDisplayGetter() {
        return Strings.S.getter("wireComponent");
    }

    @Override
    public String getName() {
        return "Wire";
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        AttributeOption dir = attrs.getValue(Wire.DIR_ATTR);
        Integer len = attrs.getValue(Wire.LEN_ATTR);
        return dir == Wire.VALUE_HORZ ? Bounds.create(0, -2, len, 5) : Bounds.create(-2, 0, 5, len);
    }

    @Override
    public boolean isHDLSupportedComponent(AttributeSet attrs) {
        return true;
    }
}

