/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.CircuitWires;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.SplitterDistributeItem;
import com.cburch.logisim.circuit.SplitterFactory;
import com.cburch.logisim.circuit.SplitterPainter;
import com.cburch.logisim.circuit.SplitterParameters;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.ToolTipMaker;
import com.cburch.logisim.tools.WireRepair;
import com.cburch.logisim.tools.WireRepairData;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Graphics;
import javax.swing.JPopupMenu;

public class Splitter
extends ManagedComponent
implements WireRepair,
ToolTipMaker,
MenuExtender,
AttributeListener {
    public static final String _ID = "Splitter";
    private boolean isMarked = false;
    byte[] bitThread;
    CircuitWires.SplitterData wireData;

    private static void appendBuf(StringBuilder buf, int start, int end) {
        if (buf.length() > 0) {
            buf.append(",");
        }
        if (start == end) {
            buf.append(start);
        } else {
            buf.append(start).append("-").append(end);
        }
    }

    public void setMarked(boolean value) {
        this.isMarked = value;
    }

    public boolean isMarked() {
        return this.isMarked;
    }

    public Splitter(Location loc, AttributeSet attrs) {
        super(loc, attrs, 3);
        this.configureComponent();
        attrs.addAttributeListener(this);
    }

    @Override
    public void attributeListChanged(AttributeEvent e) {
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        this.configureComponent();
    }

    private synchronized void configureComponent() {
        SplitterAttributes attrs = (SplitterAttributes)this.getAttributeSet();
        SplitterParameters parms = attrs.getParameters();
        int fanout = attrs.fanout;
        byte[] bitEnd = attrs.bitEnd;
        this.bitThread = new byte[bitEnd.length];
        byte[] endWidth = new byte[fanout + 1];
        endWidth[0] = (byte)bitEnd.length;
        for (int i = 0; i < bitEnd.length; ++i) {
            byte thr = bitEnd[i];
            if (thr > 0) {
                this.bitThread[i] = endWidth[thr];
                byte by = thr;
                endWidth[by] = (byte)(endWidth[by] + 1);
                continue;
            }
            this.bitThread[i] = -1;
        }
        Location origin = this.getLocation();
        int x = origin.getX() + parms.getEnd0X();
        int y = origin.getY() + parms.getEnd0Y();
        int dx = parms.getEndToEndDeltaX();
        int dy = parms.getEndToEndDeltaY();
        EndData[] ends = new EndData[fanout + 1];
        ends[0] = new EndData(origin, BitWidth.create(bitEnd.length), 3);
        for (int i = 0; i < fanout; ++i) {
            ends[i + 1] = new EndData(Location.create(x, y, true), BitWidth.create(endWidth[i + 1]), 3);
            x += dx;
            y += dy;
        }
        this.wireData = new CircuitWires.SplitterData(fanout);
        this.setEnds(ends);
        this.recomputeBounds();
        this.fireComponentInvalidated(new ComponentEvent(this));
    }

    @Override
    public void configureMenu(JPopupMenu menu, Project proj) {
        menu.addSeparator();
        menu.add(new SplitterDistributeItem(proj, this, 1));
        menu.add(new SplitterDistributeItem(proj, this, -1));
    }

    @Override
    public boolean contains(Location loc) {
        if (super.contains(loc)) {
            Location myLoc = this.getLocation();
            Direction facing = this.getAttributeSet().getValue(StdAttr.FACING);
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return Math.abs(loc.getX() - myLoc.getX()) > 5 || loc.manhattanDistanceTo(myLoc) <= 5;
            }
            return Math.abs(loc.getY() - myLoc.getY()) > 5 || loc.manhattanDistanceTo(myLoc) <= 5;
        }
        return false;
    }

    @Override
    public void draw(ComponentDrawContext context) {
        SplitterAttributes attrs = (SplitterAttributes)this.getAttributeSet();
        if (attrs.appear == SplitterAttributes.APPEAR_LEGACY) {
            SplitterPainter.drawLegacy(context, attrs, this.getLocation());
        } else {
            Location loc = this.getLocation();
            SplitterPainter.drawLines(context, attrs, loc);
            SplitterPainter.drawLabels(context, attrs, loc);
            context.drawPins(this);
        }
        if (this.isMarked) {
            Graphics g = context.getGraphics();
            Bounds bds = this.getBounds();
            g.setColor(Netlist.DRC_INSTANCE_MARK_COLOR);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawRoundRect(bds.getX() - 10, bds.getY() - 10, bds.getWidth() + 20, bds.getHeight() + 20, 20, 20);
        }
    }

    public byte[] getEndpoints() {
        return ((SplitterAttributes)this.getAttributeSet()).bitEnd;
    }

    @Override
    public ComponentFactory getFactory() {
        return SplitterFactory.instance;
    }

    @Override
    public void setFactory(ComponentFactory fact) {
    }

    @Override
    public Object getFeature(Object key) {
        if (key == WireRepair.class) {
            return this;
        }
        if (key == ToolTipMaker.class) {
            return this;
        }
        if (key == MenuExtender.class) {
            return this;
        }
        return super.getFeature(key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getToolTip(ComponentUserEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation.applyExpressionRewriter(ArithmeticOperation.java:171)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void propagate(CircuitState state) {
    }

    @Override
    public boolean shouldRepairWire(WireRepairData data) {
        return true;
    }
}

