/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.HashSet;

class PropagationPoints {
    private final HashSet<Entry<Location>> data = new HashSet();
    private final HashSet<Entry<Component>> pendingInputs = new HashSet();

    PropagationPoints() {
    }

    void addPendingInput(CircuitState state, Component comp) {
        this.pendingInputs.add(new Entry<Component>(state, comp));
    }

    void add(CircuitState state, Location loc) {
        this.data.add(new Entry<Location>(state, loc));
    }

    private void addSubstates(HashMap<CircuitState, CircuitState> map, CircuitState source, CircuitState value) {
        map.put(source, value);
        for (CircuitState s : source.getSubstates()) {
            this.addSubstates(map, s, value);
        }
    }

    void clear() {
        this.data.clear();
        this.pendingInputs.clear();
    }

    void draw(ComponentDrawContext context) {
        if (this.data.isEmpty()) {
            return;
        }
        CircuitState circState = context.getCircuitState();
        HashMap<CircuitState, CircuitState> stateMap = new HashMap<CircuitState, CircuitState>();
        for (CircuitState state : circState.getSubstates()) {
            this.addSubstates(stateMap, state, state);
        }
        Graphics g = context.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        for (Entry<Location> entry : this.data) {
            if (entry.state == circState) {
                Location p = (Location)entry.item;
                g.drawOval(p.getX() - 4, p.getY() - 4, 8, 8);
                continue;
            }
            if (!stateMap.containsKey(entry.state)) continue;
            CircuitState subState = stateMap.get(entry.state);
            Component subCircuit = subState.getSubcircuit();
            Bounds bound = subCircuit.getBounds();
            g.drawRect(bound.getX(), bound.getY(), bound.getWidth(), bound.getHeight());
        }
        GraphicsUtil.switchToWidth(g, 1);
    }

    void drawPendingInputs(ComponentDrawContext context) {
        if (this.pendingInputs.isEmpty()) {
            return;
        }
        CircuitState state = context.getCircuitState();
        HashMap<CircuitState, CircuitState> stateMap = new HashMap<CircuitState, CircuitState>();
        for (CircuitState s : state.getSubstates()) {
            this.addSubstates(stateMap, s, s);
        }
        Graphics g = context.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        for (Entry<Component> e : this.pendingInputs) {
            Component comp;
            if (e.state == state) {
                comp = (Component)e.item;
            } else {
                if (!stateMap.containsKey(e.state)) continue;
                comp = stateMap.get(e.state).getSubcircuit();
            }
            Bounds b = comp.getBounds();
            g.drawRect(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
        GraphicsUtil.switchToWidth(g, 1);
    }

    String getSingleStepMessage() {
        String signalsChanged = this.data.isEmpty() ? "no" : String.valueOf(this.data.size());
        String inputSignals = this.pendingInputs.isEmpty() ? "no" : String.valueOf(this.pendingInputs.size());
        return Strings.S.get("singleStepMessage", signalsChanged, inputSignals);
    }

    private static class Entry<T> {
        private final CircuitState state;
        private final T item;

        private Entry(CircuitState state, T item) {
            this.state = state;
            this.item = item;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof Entry) {
                Entry o = (Entry)other;
                bl = this.state.equals(o.state) && this.item.equals(o.item);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.state.hashCode() * 31 + this.item.hashCode();
        }
    }
}

