/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.gray;

import com.cburch.gray.CounterData;
import com.cburch.gray.GrayIncrementer;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;

class SimpleGrayCounter
extends InstanceFactory {
    public static final String _ID = "Gray Counter (Simple)";
    private static final BitWidth BIT_WIDTH = BitWidth.create(4);

    public SimpleGrayCounter() {
        super(_ID);
        this.setOffsetBounds(Bounds.create(-30, -15, 30, 30));
        this.setPorts(new Port[]{new Port(-30, 0, "input", 1), new Port(0, 0, "output", BIT_WIDTH.getWidth())});
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.drawBounds();
        painter.drawClock(0, Direction.EAST);
        painter.drawPort(1);
        if (painter.getShowState()) {
            CounterData state = CounterData.get(painter, BIT_WIDTH);
            Bounds bds = painter.getBounds();
            GraphicsUtil.drawCenteredText(painter.getGraphics(), StringUtil.toHexString(BIT_WIDTH.getWidth(), state.getValue().toLongValue()), bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        CounterData cur = CounterData.get(state, BIT_WIDTH);
        boolean trigger = cur.updateClock(state.getPortValue(0));
        if (trigger) {
            cur.setValue(GrayIncrementer.nextGray(cur.getValue()));
        }
        state.setPort(1, cur.getValue(), 9);
    }
}

