/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.gray;

import com.cburch.gray.CounterData;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class CounterPoker
extends InstancePoker {
    @Override
    public boolean init(InstanceState state, MouseEvent e) {
        return state.getInstance().getBounds().contains(e.getX(), e.getY());
    }

    @Override
    public void keyTyped(InstanceState state, KeyEvent e) {
        int val = Character.digit(e.getKeyChar(), 16);
        BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
        if (val < 0 || ((long)val & width.getMask()) != (long)val) {
            return;
        }
        CounterData cur = CounterData.get(state, width);
        long newVal = cur.getValue().toLongValue() * 16L + (long)val & width.getMask();
        Value newValue = Value.createKnown(width, newVal);
        cur.setValue(newValue);
        state.fireInvalidated();
    }

    @Override
    public void paint(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        int len = (painter.getAttributeValue(StdAttr.WIDTH).getWidth() + 3) / 4;
        Graphics gfx = painter.getGraphics();
        gfx.setColor(Color.RED);
        int width = 7 * len + 2;
        int height = 16;
        gfx.drawRect(bds.getX() + (bds.getWidth() - width) / 2, bds.getY() + (bds.getHeight() - 16) / 2, width, 16);
        gfx.setColor(Color.BLACK);
    }
}

