/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.util;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;

public class TextMetrics {
    private static final Canvas canvas = new Canvas();
    public int ascent;
    public int descent;
    public int leading;
    public int height;
    public int width;

    public TextMetrics(Graphics g) {
        this(g, null, null);
    }

    public TextMetrics(Graphics g, String text) {
        this(g, null, text);
    }

    public TextMetrics(Graphics g, Font font) {
        this(g, font, null);
    }

    public TextMetrics(Graphics g, Font font, String text) {
        if (g == null) {
            throw new IllegalStateException("need g");
        }
        if (font == null) {
            font = g.getFont();
        }
        FontRenderContext fr = ((Graphics2D)g).getFontRenderContext();
        if (text == null) {
            text = "\u00c4Ay";
            this.width = 0;
        } else {
            this.width = (int)font.getStringBounds(text, fr).getWidth();
        }
        LineMetrics lm = font.getLineMetrics(text, fr);
        this.ascent = (int)Math.ceil(lm.getAscent());
        this.descent = (int)Math.ceil(lm.getDescent());
        this.leading = (int)Math.ceil(lm.getLeading());
        this.height = this.ascent + this.descent + this.leading;
    }

    public TextMetrics(Component c, Font font, String text) {
        if (c == null) {
            c = canvas;
        }
        if (font == null) {
            font = c.getFont();
        }
        FontMetrics fm = c.getFontMetrics(font);
        this.width = text != null ? fm.stringWidth(text) : 0;
        this.ascent = fm.getAscent();
        this.descent = fm.getDescent();
        this.leading = 0;
        this.height = this.ascent + this.descent + this.leading;
    }
}

