/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ModelTranslateAction
extends ModelAction {
    private final Set<CanvasObject> moved;
    private final int dx;
    private final int dy;

    public ModelTranslateAction(CanvasModel model, Collection<CanvasObject> moved, int dx, int dy) {
        super(model);
        this.moved = new HashSet<CanvasObject>(moved);
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    void doSub(CanvasModel model) {
        model.translateObjects(this.moved, this.dx, this.dy);
    }

    @Override
    public String getName() {
        return Strings.S.get("actionTranslate", ModelTranslateAction.getShapesName(this.moved));
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        return Collections.unmodifiableSet(this.moved);
    }

    @Override
    void undoSub(CanvasModel model) {
        model.translateObjects(this.moved, -this.dx, -this.dy);
    }
}

