/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.sim;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.hdl.VhdlEntityComponent;
import com.cburch.logisim.util.FileUtil;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import com.cburch.logisim.vhdl.base.VhdlEntityAttributes;
import com.cburch.logisim.vhdl.base.VhdlParser;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlSimulatorVhdlTop {
    static final Logger logger = LoggerFactory.getLogger(VhdlSimulatorVhdlTop.class);
    private boolean valid = false;
    private final VhdlSimulatorTop vhdlSimulator;
    private boolean firstPort;
    private boolean firstComp;
    private boolean firstMap;

    VhdlSimulatorVhdlTop(VhdlSimulatorTop vs) {
        this.vhdlSimulator = vs;
    }

    public void fireInvalidated() {
        this.valid = false;
    }

    public void generate(List<Component> comps) {
        String template;
        if (this.valid) {
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder ports = new StringBuilder();
        ports.append(String.format("Autogenerated by %s --", "Logisim-evolution v4.0.0"));
        ports.append(lineSeparator);
        StringBuilder components = new StringBuilder();
        components.append(String.format("Autogenerated by %s --", "Logisim-evolution v4.0.0"));
        components.append(lineSeparator);
        StringBuilder map = new StringBuilder();
        map.append(String.format("Autogenerated by %s --", "Logisim-evolution v4.0.0"));
        map.append(lineSeparator);
        this.firstMap = true;
        this.firstComp = true;
        this.firstPort = true;
        String[] type = new String[]{"inout", "input", "output"};
        for (Component comp : comps) {
            String vhdlEntityName;
            InstanceState state = this.vhdlSimulator.getProject().getCircuitState().getInstanceState(comp);
            ComponentFactory fac = comp.getFactory();
            ArrayList<VhdlParser.PortDescription> myPorts = new ArrayList<VhdlParser.PortDescription>();
            if (fac instanceof VhdlEntity) {
                vhdlEntityName = ((VhdlEntity)fac).getSimName(state.getInstance().getAttributeSet());
                myPorts.addAll(((VhdlEntityAttributes)state.getAttributeSet()).getContent().getPorts());
            } else {
                vhdlEntityName = ((VhdlEntityComponent)fac).getSimName(state.getInstance().getAttributeSet());
                for (HdlModel.PortDescription port : state.getAttributeValue(VhdlEntityComponent.CONTENT_ATTR).getPorts()) {
                    VhdlParser.PortDescription nport = new VhdlParser.PortDescription(port.getName(), port.getType(), port.getWidthInt());
                    myPorts.add(nport);
                }
            }
            for (VhdlParser.PortDescription port : myPorts) {
                if (!this.firstPort) {
                    ports.append(";");
                    ports.append(lineSeparator);
                } else {
                    this.firstPort = false;
                }
                String portName = vhdlEntityName + "_" + port.getName();
                ports.append("      ").append(portName).append(" : ").append(port.getVhdlType()).append(" std_logic");
                int width = port.getWidth().getWidth();
                if (width <= 1) continue;
                ports.append("_vector(").append(width - 1).append(" downto 0)");
            }
            components.append("   component ").append(vhdlEntityName);
            components.append(lineSeparator);
            components.append("      port (");
            components.append(lineSeparator);
            this.firstComp = true;
            for (VhdlParser.PortDescription port : myPorts) {
                if (!this.firstComp) {
                    components.append(";");
                    components.append(lineSeparator);
                } else {
                    this.firstComp = false;
                }
                components.append("         ").append(port.getName()).append(" : ").append(port.getVhdlType()).append(" std_logic");
                int width = port.getWidth().getWidth();
                if (width <= 1) continue;
                components.append("_vector(").append(width - 1).append(" downto 0)");
            }
            components.append(lineSeparator);
            components.append("      );");
            components.append(lineSeparator);
            components.append("   end component ;");
            components.append(lineSeparator);
            components.append("   ");
            components.append(lineSeparator);
            map.append("   ").append(vhdlEntityName).append("_map : ").append(vhdlEntityName).append(" port map (");
            map.append(lineSeparator);
            this.firstMap = true;
            for (VhdlParser.PortDescription port : myPorts) {
                if (!this.firstMap) {
                    map.append(",");
                    map.append(lineSeparator);
                } else {
                    this.firstMap = false;
                }
                map.append("      ").append(port.getName()).append(" => ").append(vhdlEntityName).append("_").append(port.getName());
            }
            map.append(lineSeparator);
            map.append("   );");
            map.append(lineSeparator);
            map.append("   ");
            map.append(lineSeparator);
        }
        ports.append(lineSeparator);
        ports.append("      ---------------------------");
        ports.append(lineSeparator);
        components.append("   ---------------------------");
        components.append(lineSeparator);
        map.append("   ---------------------------");
        map.append(lineSeparator);
        try {
            template = new String(FileUtil.getBytes(this.getClass().getResourceAsStream("/resources/logisim/hdl/top_sim.templ")));
        }
        catch (IOException e) {
            logger.error("Could not read template : {}", (Object)e.getMessage());
            return;
        }
        template = template.replaceAll("%date%", LocaleManager.PARSER_SDF.format(new Date())).replaceAll("%ports%", ports.toString()).replaceAll("%components%", components.toString()).replaceAll("%map%", map.toString());
        try {
            PrintWriter writer = new PrintWriter(VhdlSimConstants.SIM_SRC_PATH + "top_sim.vhdl", StandardCharsets.UTF_8);
            writer.print(template);
            writer.close();
        }
        catch (IOException e) {
            logger.error("Could not create top_sim file : {}", (Object)e.getMessage());
            e.printStackTrace();
            return;
        }
        this.valid = true;
    }
}

