/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

public class Cache {
    private final int mask;
    private final Object[] data;

    public Cache() {
        this(8);
    }

    public Cache(int logSize) {
        if (logSize > 12) {
            logSize = 12;
        }
        this.data = new Object[1 << logSize];
        this.mask = this.data.length - 1;
    }

    public Object get(int hashCode) {
        return this.data[hashCode & this.mask];
    }

    public Object get(Object value) {
        if (value == null) {
            return null;
        }
        int code = value.hashCode() & this.mask;
        Object ret = this.data[code];
        if (ret != null && ret.equals(value)) {
            return ret;
        }
        this.data[code] = value;
        return value;
    }

    public void put(int hashCode, Object value) {
        if (value != null) {
            this.data[hashCode & this.mask] = value;
        }
    }
}

