/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.draw.shapes.DrawAttr;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LedShape
extends DynamicElement {
    static final int DEFAULT_RADIUS = 5;

    public LedShape(int x, int y, DynamicElement.Path p) {
        super(p, Bounds.create(x, y, 10, 10));
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        int qy;
        double dy;
        int x = this.bounds.getX();
        int y = this.bounds.getY();
        int w = this.bounds.getWidth();
        int h = this.bounds.getHeight();
        int qx = loc.getX();
        double dx = (double)qx - ((double)x + 0.5 * (double)w);
        double sum = dx * dx / (double)(w * w) + (dy = (double)(qy = loc.getY()) - ((double)y + 0.5 * (double)h)) * dy / (double)(h * h);
        return sum <= 0.25;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return UnmodifiableList.create(new Attribute[]{DrawAttr.STROKE_WIDTH, ATTR_LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR});
    }

    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        Color offColor = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_OFF_COLOR);
        Color onColor = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_ON_COLOR);
        int x = this.bounds.getX() + 1;
        int y = this.bounds.getY() + 1;
        int w = this.bounds.getWidth() - 2;
        int h = this.bounds.getHeight() - 2;
        GraphicsUtil.switchToWidth(g, this.strokeWidth);
        if (state == null) {
            g.setColor(offColor);
            g.fillOval(x, y, w, h);
            g.setColor(DynamicElement.COLOR);
        } else {
            Boolean activ = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_ACTIVE);
            Value desired = activ != false ? Value.TRUE : Value.FALSE;
            InstanceDataSingleton data = (InstanceDataSingleton)this.getData(state);
            Value val = data == null ? Value.FALSE : (Value)data.getValue();
            g.setColor(val == desired ? onColor : offColor);
            g.fillOval(x, y, w, h);
            g.setColor(Color.darkGray);
        }
        g.drawOval(x, y, w, h);
        this.drawLabel(g);
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-led"));
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("ledComponent");
    }

    public String toString() {
        return "Led:" + String.valueOf(this.getBounds());
    }
}

