/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.AbstractGateHdlGenerator;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.GateFunctions;
import com.cburch.logisim.std.gates.PainterDin;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.std.gates.XorGate;
import com.cburch.logisim.tools.WireRepairData;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics2D;

class XnorGate
extends AbstractGate {
    public static final XnorGate FACTORY = new XnorGate();

    private XnorGate() {
        super("XNOR Gate", Strings.S.getter("xnorGateComponent"), true, new XNorGateHdlGeneratorFactory());
        this.setNegateOutput(true);
        this.setAdditionalWidth(10);
        this.setPaintInputLines(true);
    }

    @Override
    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        return Expressions.not(XorGate.xorExpression(inputs, numInputs));
    }

    @Override
    protected Value computeOutput(Value[] inputs, int numInputs, InstanceState state) {
        AttributeOption behavior = state.getAttributeValue(GateAttributes.ATTR_XOR);
        if (behavior == GateAttributes.XOR_ODD) {
            return GateFunctions.computeOddParity(inputs, numInputs).not();
        }
        return GateFunctions.computeExactlyOne(inputs, numInputs).not();
    }

    @Override
    protected Value getIdentity() {
        return Value.FALSE;
    }

    @Override
    protected String getRectangularLabel(AttributeSet attrs) {
        return XorGate.FACTORY.getRectangularLabel(attrs);
    }

    @Override
    protected void paintDinShape(InstancePainter painter, int width, int height, int inputs) {
        PainterDin.paintXnor(painter, width, height, false);
    }

    @Override
    public void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize) {
        XorGate.paintIconANSI(g, iconSize, borderSize, negateSize, true);
    }

    @Override
    protected void paintShape(InstancePainter painter, int width, int height) {
        PainterShaped.paintXor(painter, width, height);
    }

    @Override
    protected boolean shouldRepairWire(Instance instance, WireRepairData data) {
        return !data.getPoint().equals(instance.getLocation());
    }

    private static class XNorGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private XNorGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
            return LineBuffer.getBuffer().add(isOneHot ? this.getOneHot(true, nrOfInputs, bitwidth > 1) : XNorGateHdlGeneratorFactory.getParity(true, nrOfInputs, bitwidth > 1));
        }
    }
}

