/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.gui;

import com.cburch.contracts.BaseDocumentListenerContract;
import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.icons.CompileIcon;
import com.cburch.logisim.gui.icons.ErrorIcon;
import com.cburch.logisim.gui.icons.InfoIcon;
import com.cburch.logisim.gui.icons.OpenSaveIcon;
import com.cburch.logisim.gui.icons.RunIcon;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.gui.ListeningFrame;
import com.cburch.logisim.soc.util.Assembler;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.util.LocaleListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class AssemblerPanel
extends JPanel
implements BaseMouseListenerContract,
LocaleListener,
ActionListener,
BaseKeyListenerContract,
BaseDocumentListenerContract,
CaretListener,
BaseWindowListenerContract {
    private static final long serialVersionUID = 1L;
    private final Assembler assembler;
    private final RSyntaxTextArea asmWindow;
    private final RTextScrollPane debugScrollPane;
    private final JLabel compileLabel = new JLabel();
    private final JLabel openLabel = new JLabel();
    private final JLabel saveLabel = new JLabel();
    private final JLabel saveAsLabel = new JLabel();
    private final JLabel runLabel = new JLabel();
    private final JLabel helpLabel = new JLabel();
    private final JLabel nextErrorLabel = new JLabel();
    private final JLabel prevErrorLabel = new JLabel();
    private final JLabel lineLabel = new JLabel();
    private final JMenuItem openMenuItem = new JMenuItem();
    private final JMenuItem saveMenuItem = new JMenuItem();
    private final JMenuItem saveAsMenuItem = new JMenuItem();
    private final ListeningFrame parent;
    private final SocProcessorInterface cpu;
    private final CircuitState circuitState;
    private int lineNumber = 1;
    private int numberOfLines = 1;
    private boolean documentChanged = false;
    private File textFile;

    public AssemblerPanel(ListeningFrame parent, String highLiter, AssemblerInterface assembler, SocProcessorInterface cpu, CircuitState state) {
        parent.addWindowListener(this);
        this.parent = parent;
        this.cpu = cpu;
        this.circuitState = state;
        this.textFile = null;
        this.asmWindow = new RSyntaxTextArea(20, 60);
        this.asmWindow.setSyntaxEditingStyle(highLiter);
        this.asmWindow.setEditable(true);
        this.asmWindow.addKeyListener(this);
        this.asmWindow.getDocument().addDocumentListener(this);
        this.asmWindow.addCaretListener(this);
        JPopupMenu popUp = this.asmWindow.getPopupMenu();
        popUp.remove(popUp.getComponentCount() - 1);
        popUp.add(this.openMenuItem);
        this.openMenuItem.addActionListener(this);
        popUp.add(this.saveMenuItem);
        this.saveMenuItem.addActionListener(this);
        popUp.add(this.saveAsMenuItem);
        this.saveAsMenuItem.addActionListener(this);
        this.asmWindow.setPopupMenu(popUp);
        this.debugScrollPane = new RTextScrollPane(this.asmWindow);
        this.debugScrollPane.setLineNumbersEnabled(true);
        this.debugScrollPane.setIconRowHeaderEnabled(true);
        this.debugScrollPane.getGutter().setBookmarkingEnabled(false);
        Box info = Box.createHorizontalBox();
        this.openLabel.setIcon(new OpenSaveIcon(0));
        this.openLabel.addMouseListener(this);
        info.add(this.openLabel);
        this.saveLabel.setIcon(new OpenSaveIcon(1));
        this.saveLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.saveLabel);
        this.saveAsLabel.setIcon(new OpenSaveIcon(2));
        this.saveAsLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.saveAsLabel);
        this.compileLabel.setIcon(new CompileIcon());
        this.compileLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.compileLabel);
        this.prevErrorLabel.setIcon(new ErrorIcon(false, true));
        this.prevErrorLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.prevErrorLabel);
        this.nextErrorLabel.setIcon(new ErrorIcon(true, false));
        this.nextErrorLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.nextErrorLabel);
        this.runLabel.setIcon(new RunIcon());
        this.runLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.runLabel);
        this.helpLabel.setIcon(new InfoIcon());
        this.helpLabel.addMouseListener(this);
        info.add(Box.createHorizontalStrut(5));
        info.add(this.helpLabel);
        info.add(Box.createHorizontalGlue());
        this.lineLabel.setOpaque(true);
        info.add(this.lineLabel);
        info.setPreferredSize(new Dimension(40, AppPreferences.getScaled(20)));
        this.setLayout(new BorderLayout());
        info.add(Box.createHorizontalStrut(5));
        this.add((Component)info, "North");
        this.add(this.debugScrollPane);
        this.assembler = new Assembler(assembler, this.debugScrollPane);
        this.asmWindow.addParser(this.assembler);
        this.localeChanged();
    }

    private void openFile() {
        int ret;
        if (this.documentChanged && (ret = OptionPane.showConfirmDialog(this.parent, Strings.S.get("AsmPanDocumentChangedSave"), this.parent.getParentTitle(), 0)) == 0) {
            if (this.textFile == null) {
                OptionPane.showMessageDialog(this.parent, Strings.S.get("AsmPanSaveFirstBeforeOpen"));
                return;
            }
            this.saveFile(false);
        }
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Strings.S.get("AsmPanAmsFileExtention"), "S", "asm");
        chooser.setDialogTitle(this.parent.getParentTitle() + ": " + Strings.S.get("AsmPanReadAsmFile"));
        chooser.setFileFilter(filter);
        int ret2 = chooser.showOpenDialog(this.parent);
        if (ret2 != 0) {
            return;
        }
        this.textFile = chooser.getSelectedFile();
        try {
            String st;
            BufferedReader reader = new BufferedReader(new FileReader(this.textFile));
            StringBuilder s = new StringBuilder();
            while ((st = reader.readLine()) != null) {
                s.append(st).append("\n");
            }
            reader.close();
            this.asmWindow.setText(s.toString());
        }
        catch (IOException e) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("AsmPanErrorReadingFile", this.textFile.getName()), this.parent.getParentTitle(), 0);
            this.textFile = null;
            return;
        }
        this.asmWindow.setCaretPosition(0);
        this.documentChanged = false;
        this.assembler.reset();
        if (!this.assembler.assemble()) {
            this.asmWindow.setCaretPosition(this.assembler.getErrorPositions().get(0));
        }
        this.updateLineNumber();
    }

    private void saveFile(boolean AskFileName) {
        if (!this.documentChanged) {
            return;
        }
        if (AskFileName || this.textFile == null) {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(Strings.S.get("AsmPanAmsFileExtention"), "S", "asm");
            chooser.setDialogTitle(this.parent.getParentTitle() + ": " + Strings.S.get("AsmPanSaveAsmFile"));
            chooser.setFileFilter(filter);
            int ret = chooser.showOpenDialog(this.parent);
            if (ret != 0) {
                return;
            }
            this.textFile = chooser.getSelectedFile();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.textFile)));
            writer.write(this.asmWindow.getText());
            writer.close();
        }
        catch (IOException e) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("AsmPanErrorCreateFile", this.textFile.getName()), this.parent.getParentTitle(), 0);
        }
        this.documentChanged = false;
        this.updateLineNumber();
    }

    private boolean assemble(boolean showWindow) {
        boolean result = this.assembler.assemble();
        if (!result) {
            this.asmWindow.setCaretPosition(this.assembler.getErrorPositions().get(0));
        } else if (showWindow) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("AssemblerAssembleSuccess"));
        }
        return result;
    }

    private void runProgram() {
        if (!this.assemble(false)) {
            return;
        }
        long entryPoint = this.assembler.getEntryPoint();
        if (entryPoint < 0L) {
            return;
        }
        if (!this.assembler.download(this.cpu, this.circuitState)) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("AssemblerUnableToDownload"), Strings.S.get("AsmPanRun"), 0);
            return;
        }
        this.cpu.setEntryPointandReset(this.circuitState, entryPoint, null, this.assembler.getSectionHeader());
        OptionPane.showMessageDialog(this.parent, Strings.S.get("AssemblerRunSuccess"), Strings.S.get("AsmPanRun"), 1);
    }

    private void updateLineNumber() {
        this.lineLabel.setBackground(this.documentChanged ? Color.YELLOW : Color.WHITE);
        this.lineLabel.setText(Strings.S.get("RV32imAsmLineIndicator", this.lineNumber, this.numberOfLines));
        this.lineLabel.repaint();
    }

    private void nextError(boolean after) {
        int carretPos = this.asmWindow.getCaretPosition();
        List<Integer> errorPositions = this.assembler.getErrorPositions();
        if (errorPositions.isEmpty()) {
            return;
        }
        int findex = -1;
        for (int index = 0; findex < 0 && index < errorPositions.size(); ++index) {
            if (carretPos > errorPositions.get(index)) continue;
            findex = index;
        }
        if (after) {
            if (findex < 0 || findex == errorPositions.size() - 1) {
                this.asmWindow.setCaretPosition(errorPositions.get(0));
            } else {
                this.asmWindow.setCaretPosition(errorPositions.get(findex + 1));
            }
        } else if (findex <= 0) {
            this.asmWindow.setCaretPosition(errorPositions.get(errorPositions.size() - 1));
        } else {
            this.asmWindow.setCaretPosition(errorPositions.get(findex - 1));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.openLabel) {
            this.openFile();
        } else if (source == this.saveLabel) {
            this.saveFile(false);
        } else if (source == this.saveAsLabel) {
            this.saveFile(true);
        } else if (source == this.compileLabel) {
            this.assemble(true);
        } else if (source == this.nextErrorLabel) {
            this.nextError(true);
        } else if (source == this.prevErrorLabel) {
            this.nextError(false);
        } else if (source == this.runLabel) {
            this.runProgram();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.openMenuItem) {
            this.openFile();
        } else if (source == this.saveMenuItem) {
            this.saveFile(false);
        } else if (source == this.saveAsMenuItem) {
            this.saveFile(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!e.isAltDown() && e.isControlDown() && e.getKeyCode() == 83) {
            this.saveFile(false);
        } else if (!e.isAltDown() && e.isControlDown() && e.getKeyCode() == 76) {
            this.openFile();
        } else if (e.isAltDown() && !e.isControlDown() && e.getKeyCode() == 65) {
            this.assemble(true);
        } else if (e.isAltDown() && !e.isControlDown() && e.getKeyCode() == 82) {
            this.runProgram();
        } else if (!e.isAltDown() && e.isControlDown() && e.getKeyCode() == 78) {
            this.nextError(true);
        } else if (!e.isAltDown() && e.isControlDown() && e.getKeyCode() == 80) {
            this.nextError(false);
        }
    }

    @Override
    public void localeChanged() {
        this.openLabel.setToolTipText(Strings.S.get("AsmPanOpenFile"));
        this.saveLabel.setToolTipText(Strings.S.get("AsmPanSaveFile"));
        this.saveAsLabel.setToolTipText(Strings.S.get("AsmPanSaveFileAs"));
        this.compileLabel.setToolTipText(Strings.S.get("AsmPanAssemble"));
        this.nextErrorLabel.setToolTipText(Strings.S.get("AsmPanNextError"));
        this.prevErrorLabel.setToolTipText(Strings.S.get("AsmPanPreviousError"));
        this.runLabel.setToolTipText(Strings.S.get("AsmPanRun"));
        this.openMenuItem.setText(Strings.S.get("AsmPanOpenFile"));
        this.saveMenuItem.setText(Strings.S.get("AsmPanSaveFile"));
        this.saveAsMenuItem.setText(Strings.S.get("AsmPanSaveFileAs"));
        this.updateLineNumber();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged = true;
        this.assembler.checkAndBuildTokens(this.asmWindow.getCaretLineNumber());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged = true;
        this.assembler.checkAndBuildTokens(this.asmWindow.getCaretLineNumber());
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.numberOfLines = this.asmWindow.getDocument().getDefaultRootElement().getElementCount();
        this.lineNumber = this.asmWindow.getCaretLineNumber() + 1;
        this.updateLineNumber();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.documentChanged) {
            this.parent.setVisible(true);
            int ret = OptionPane.showConfirmDialog(this.parent, Strings.S.get("AsmPanDocumentChangedSave"), this.parent.getParentTitle(), 0);
            if (ret == 0) {
                this.saveFile(false);
            }
            this.documentChanged = false;
            this.parent.setVisible(false);
        }
        this.asmWindow.setText("");
        this.assembler.reset();
        this.documentChanged = false;
        this.updateLineNumber();
    }
}

