/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.PropagationPoints;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.circuit.Splitter;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LinkedQueue;
import com.cburch.logisim.util.QNode;
import com.cburch.logisim.util.QNodeQueue;
import com.cburch.logisim.util.QueueOfQueues;
import com.cburch.logisim.util.SplayQueue;
import java.lang.ref.WeakReference;
import java.util.PriorityQueue;
import java.util.Random;

public class Propagator {
    private final CircuitState root;
    private volatile int simLimit;
    private volatile int simRandomShift;
    private final QNodeQueue<SimulatorEvent> toProcess;
    private int clock = 0;
    private boolean isOscillating = false;
    private boolean oscAdding = false;
    private PropagationPoints oscPoints = new PropagationPoints();
    private int halfClockCycles = 0;
    private final Random noiseSource = new Random();
    private int noiseCount = 0;
    private int eventSerialNumber = 0;
    static int lastId = 0;
    final int id = lastId++;

    public Propagator(CircuitState root) {
        String simQueueType;
        this.root = root;
        Listener l = new Listener(this);
        root.getProject().getOptions().getAttributeSet().addAttributeListener(l);
        this.toProcess = switch (simQueueType = AppPreferences.SIMULATION_QUEUE.get()) {
            case "listOfQueues", "treeOfQueues" -> new QueueOfQueues(simQueueType);
            case "linked" -> new LinkedQueue();
            case "splay" -> new SplayQueue();
            default -> new PriorityEventQueue();
        };
        this.updateRandomness();
        this.updateSimLimit();
    }

    public void drawOscillatingPoints(ComponentDrawContext context) {
        if (this.isOscillating) {
            this.oscPoints.draw(context);
        }
    }

    CircuitState getRootState() {
        return this.root;
    }

    public int getTickCount() {
        return this.halfClockCycles;
    }

    public boolean isOscillating() {
        return this.isOscillating;
    }

    boolean isPending() {
        return !this.toProcess.isEmpty();
    }

    void locationTouched(CircuitState state, Location loc) {
        if (this.oscAdding) {
            this.oscPoints.add(state, loc);
        }
    }

    public boolean propagate() {
        return this.propagate(null, null);
    }

    public boolean propagate(Simulator.ProgressListener propListener, Simulator.Event propEvent) {
        this.oscPoints.clear();
        this.root.processDirtyPoints();
        this.root.processDirtyComponents();
        int oscThreshold = this.simLimit;
        int logThreshold = 3 * oscThreshold / 4;
        int iters = 0;
        while (!this.toProcess.isEmpty()) {
            if (iters > 0 && propListener != null) {
                propListener.propagationInProgress(propEvent);
            }
            if (++iters < logThreshold) {
                this.stepInternal(null);
                continue;
            }
            if (iters < oscThreshold) {
                this.oscAdding = true;
                this.stepInternal(this.oscPoints);
                continue;
            }
            this.isOscillating = true;
            this.oscAdding = false;
            return true;
        }
        this.isOscillating = false;
        this.oscAdding = false;
        this.oscPoints.clear();
        return iters > 0;
    }

    void reset() {
        this.halfClockCycles = 0;
        this.toProcess.clear();
        this.root.reset();
        this.isOscillating = false;
    }

    void setValue(CircuitState state, Location pt, Value val, Component cause, int delay) {
        int randomShift;
        if (cause instanceof Wire || cause instanceof Splitter) {
            return;
        }
        if (delay <= 0) {
            delay = 1;
        }
        if ((randomShift = this.simRandomShift) > 0) {
            delay <<= randomShift;
            if (!(cause.getFactory() instanceof SubcircuitFactory)) {
                if (this.noiseCount > 0) {
                    --this.noiseCount;
                } else {
                    ++delay;
                    this.noiseCount = this.noiseSource.nextInt(1 << randomShift);
                }
            }
        }
        this.toProcess.add(new SimulatorEvent(this.clock + delay, this.eventSerialNumber, state, pt, cause, val));
        ++this.eventSerialNumber;
    }

    boolean step(PropagationPoints changedPoints) {
        this.oscPoints.clear();
        this.root.processDirtyPoints();
        this.root.processDirtyComponents();
        if (this.toProcess.isEmpty()) {
            return false;
        }
        PropagationPoints oldOsc = this.oscPoints;
        this.oscAdding = changedPoints != null;
        this.oscPoints = changedPoints;
        this.stepInternal(changedPoints);
        this.oscAdding = false;
        this.oscPoints = oldOsc;
        return true;
    }

    private void stepInternal(PropagationPoints changedPoints) {
        SimulatorEvent ev;
        if (this.toProcess.isEmpty()) {
            return;
        }
        this.clock = this.toProcess.peek().timeKey;
        while ((ev = this.toProcess.peek()) != null && ev.timeKey == this.clock) {
            this.toProcess.remove();
            CircuitState state = ev.state;
            if (changedPoints != null) {
                changedPoints.add(state, ev.loc);
            }
            state.markPointAsDirty(ev);
        }
        this.root.processDirtyPoints();
        this.root.processDirtyComponents();
    }

    public boolean toggleClocks() {
        ++this.halfClockCycles;
        return this.root.toggleClocks(this.halfClockCycles);
    }

    public String toString() {
        return "Prop" + this.id;
    }

    private void updateRandomness() {
        Integer rand;
        Options opts = this.root.getProject().getOptions();
        Integer val = rand = opts.getAttributeSet().getValue(Options.ATTR_SIM_RAND);
        int logVal = 0;
        while (1 << logVal < val) {
            ++logVal;
        }
        this.simRandomShift = logVal;
    }

    private void updateSimLimit() {
        Options opts = this.root.getProject().getOptions();
        Integer lim = opts.getAttributeSet().getValue(Options.ATTR_SIM_LIMIT);
        this.simLimit = lim;
    }

    private static class Listener
    implements AttributeListener {
        final WeakReference<Propagator> prop;

        public Listener(Propagator propagator) {
            this.prop = new WeakReference<Propagator>(propagator);
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Propagator p = (Propagator)this.prop.get();
            if (p == null) {
                e.getSource().removeAttributeListener(this);
            } else if (e.getAttribute().equals(Options.ATTR_SIM_RAND)) {
                p.updateRandomness();
            } else if (e.getAttribute().equals(Options.ATTR_SIM_LIMIT)) {
                p.updateSimLimit();
            }
        }
    }

    private class PriorityEventQueue<T extends QNode>
    extends PriorityQueue<T>
    implements QNodeQueue<T> {
        private PriorityEventQueue() {
        }
    }

    public static class SimulatorEvent
    extends QNode {
        final CircuitState state;
        final Location loc;
        final Component cause;
        Value val;

        private SimulatorEvent(int time, int serialNumber, CircuitState state, Location loc, Component cause, Value val) {
            super(time, serialNumber);
            this.state = state;
            this.cause = cause;
            this.loc = loc;
            this.val = val;
        }

        public SimulatorEvent cloneFor(CircuitState newState) {
            Propagator newProp = newState.getPropagator();
            int dtime = newProp.clock - this.state.getPropagator().clock;
            return new SimulatorEvent(this.timeKey + dtime, newProp.eventSerialNumber++, newState, this.loc, this.cause, this.val);
        }

        public String toString() {
            return String.valueOf(this.loc) + ":" + String.valueOf(this.val) + "(" + String.valueOf(this.cause) + ")";
        }
    }
}

