/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx;

import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.SegmentCell;
import com.dlsc.pickerfx.skins.ItemPickerSkin;
import java.util.Objects;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class ItemPicker<T>
extends Picker<T> {
    private final ListProperty<T> items = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<Callback<Segment<T, T>, SegmentCell<T>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory", segment -> new SegmentCell());

    @SafeVarargs
    public ItemPicker(T ... items) {
        this();
        this.getStyleClass().add((Object)"item-picker");
        if (items != null) {
            this.getItems().setAll((Object[])items);
        }
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(ItemPicker.class.getResource("picker.css")).toExternalForm();
    }

    public ItemPicker() {
    }

    public final ListProperty<T> itemsProperty() {
        return this.items;
    }

    public final ObservableList<T> getItems() {
        return this.items;
    }

    public final void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    protected Skin<?> createDefaultSkin() {
        return new ItemPickerSkin(this);
    }

    public final Callback<Segment<T, T>, SegmentCell<T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<Segment<T, T>, SegmentCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<Segment<T, T>, SegmentCell<T>> factory) {
        this.cellFactory.set(factory);
    }
}

