/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public class RSAPrivateKeyPKCS8
extends RSAPrivateKey
implements Streamable {
    private PrivateKeyPKCS8 a;

    public RSAPrivateKeyPKCS8() {
        this.a = new PrivateKeyPKCS8();
        this.a.setMode(0);
    }

    public RSAPrivateKeyPKCS8(byte[] byArray, File file) throws FileNotFoundException, IOException {
        this(new String(byArray), file);
    }

    public RSAPrivateKeyPKCS8(String string, File file) throws FileNotFoundException, IOException {
        this.a = new PrivateKeyPKCS8(string, file);
        super.input(new UnsyncByteArrayInputStream(this.a.getKey().getEncoded()));
    }

    public RSAPrivateKeyPKCS8(RSAPrivateKey rSAPrivateKey, RandomBitsSource randomBitsSource) throws IOException {
        this.a = new PrivateKeyPKCS8((PrivateKey)rSAPrivateKey, 0, randomBitsSource);
        super.input(new UnsyncByteArrayInputStream(rSAPrivateKey.getEncoded()));
    }

    public void setPassword(byte[] byArray) {
        this.setPassword(new String(byArray));
    }

    public void setPassword(String string) {
        this.a.setPassword(string);
    }

    public RSAPrivateKey getKey() {
        return this;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a.input(inputStream);
        super.input(new UnsyncByteArrayInputStream(this.a.getKey().getEncoded()));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
    }

    @Override
    public int length() {
        return this.a.length();
    }
}

