/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TreeNode<T> {
    private static final boolean DEFAULT_EXPANDED = true;
    public static final double USE_TREE_CELL_SIZE = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_WIDTH = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_HEIGHT = Double.NEGATIVE_INFINITY;
    private String name;
    private final ReadOnlyObjectWrapper<TreeNode<T>> parent = new ReadOnlyObjectWrapper((Object)this, "parent", null);
    private final ObservableList<TreeNode<T>> children = FXCollections.observableArrayList();
    private final ObservableList<TreeNode<T>> linkedNodes = FXCollections.observableArrayList();
    private final BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", true);
    private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value", null);
    private final DoubleProperty width = new SimpleDoubleProperty((Object)this, "width", Double.NEGATIVE_INFINITY);
    private final DoubleProperty height = new SimpleDoubleProperty((Object)this, "height", Double.NEGATIVE_INFINITY);

    public TreeNode() {
        this.children.addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(each -> each.setParent(this));
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(each -> each.setParent(null));
            }
        });
    }

    public TreeNode(T value) {
        this();
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReadOnlyObjectProperty<TreeNode<T>> parentProperty() {
        return this.parent.getReadOnlyProperty();
    }

    protected void setParent(TreeNode<T> parent) {
        this.parent.set(parent);
    }

    public TreeNode<T> getParent() {
        return (TreeNode)this.parentProperty().get();
    }

    public ObservableList<TreeNode<T>> getChildren() {
        return this.children;
    }

    public ObservableList<TreeNode<T>> getLinkedNodes() {
        return this.linkedNodes;
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public T getValue() {
        return (T)this.valueProperty().get();
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public void setValue(T value) {
        this.valueProperty().set(value);
    }

    public double getWidth() {
        return this.width.get();
    }

    public DoubleProperty widthProperty() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public double getHeight() {
        return this.height.get();
    }

    public DoubleProperty heightProperty() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height.set(height);
    }

    public void setSize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public int getDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        return 1 + this.getParent().getDepth();
    }

    public int getLevel() {
        return this.getDepth();
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public TreeNode<T> getLastChild() {
        if (!this.children.isEmpty()) {
            return (TreeNode)this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public boolean isLastChild() {
        if (this.getParent() == null || this.getParent().getChildren().isEmpty()) {
            return false;
        }
        return this == this.getParent().getLastChild();
    }

    public boolean isFirstChild() {
        if (this.getParent() == null || this.getParent().getChildren().isEmpty()) {
            return false;
        }
        return this == this.getParent().getFirstChild();
    }

    public TreeNode<T> getFirstChild() {
        if (!this.children.isEmpty()) {
            return (TreeNode)this.children.get(0);
        }
        return null;
    }

    public boolean isAncestorCollapsed() {
        for (TreeNode<T> parentNode = this.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            if (parentNode.isExpanded()) continue;
            return true;
        }
        return false;
    }

    public Stream<TreeNode<T>> stream() {
        return StreamSupport.stream(new TreeNodeSpliterator(this), false);
    }

    public String toString() {
        return "TreeNode{value=" + this.getValue() + "}";
    }

    private static class TreeNodeSpliterator<T>
    implements Spliterator<TreeNode<T>> {
        private final Queue<TreeNode<T>> queue = new LinkedList<TreeNode<T>>();

        TreeNodeSpliterator(TreeNode<T> root) {
            this.queue.add(root);
        }

        @Override
        public boolean tryAdvance(Consumer<? super TreeNode<T>> action) {
            TreeNode<T> node = this.queue.poll();
            if (node != null) {
                action.accept(node);
                this.queue.addAll((Collection<TreeNode<T>>)node.getChildren());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<TreeNode<T>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 16;
        }
    }
}

