/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.UnitStyle;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.TransformedUnit;

public final class Units
extends AbstractSystemOfUnits {
    private static final Units INSTANCE = new Units();
    public static final Unit<Mass> GRAM = Units.addUnit(Mass.class, tech.units.indriya.unit.Units.GRAM, null, true);
    public static final Unit<Mass> MILLIGRAM = Units.addUnit(Mass.class, MetricPrefix.MILLI(GRAM), null, false);
    public static final Unit<Mass> KILOGRAM = Units.addUnit(Mass.class, MetricPrefix.KILO(GRAM), null, false);
    public static final Unit<Length> METRE = Units.addUnit(Length.class, tech.units.indriya.unit.Units.METRE, null, true);
    public static final Unit<Length> CENTIMETRE = Units.addUnit(Length.class, MetricPrefix.CENTI(METRE), null, false);
    public static final Unit<Length> MILLIMETRE = Units.addUnit(Length.class, MetricPrefix.MILLI(METRE), null, false);
    public static final Unit<Length> KILOMETRE = Units.addUnit(Length.class, MetricPrefix.KILO(METRE), null, false);
    public static final Unit<Length> FOOT = Units.addUnit(Length.class, new TransformedUnit("ft", METRE, (UnitConverter)MultiplyConverter.ofRational((long)3048L, (long)10000L)), "ft", false);
    public static final Unit<Length> INCH = Units.addUnit(Length.class, new TransformedUnit("in", FOOT, (UnitConverter)MultiplyConverter.ofRational((long)1L, (long)12L)), "in", false);
    public static final Unit<Length> NAUTICAL_MILE = Units.addUnit(Length.class, new TransformedUnit("nm", METRE, (UnitConverter)MultiplyConverter.of((double)1852.0)), "nm", false);
    public static final Unit<Temperature> CELSIUS = Units.addUnit(Temperature.class, tech.units.indriya.unit.Units.CELSIUS, null, true);
    public static final Unit<Temperature> KELVIN = Units.addUnit(Temperature.class, tech.units.indriya.unit.Units.KELVIN, null, false);
    public static final Unit<Angle> DEGREE = Units.addUnit(Angle.class, new AlternateUnit(AbstractUnit.ONE, "d"), null, true);
    public static final Unit<Speed> METRE_PER_SECOND = Units.addUnit(Speed.class, tech.units.indriya.unit.Units.METRE_PER_SECOND, null, false);
    public static final Unit<Speed> KILOMETRE_PER_HOUR = Units.addUnit(Speed.class, tech.units.indriya.unit.Units.KILOMETRE_PER_HOUR, null, true);
    public static final Unit<Speed> KNOT = Units.addUnit(Speed.class, NAUTICAL_MILE.divide(tech.units.indriya.unit.Units.HOUR).asType(Speed.class), "kt", false);
    private final Map<Class<? extends Quantity<?>>, List<Unit<?>>> quantityToUnits = new HashMap();

    public static Units getInstance() {
        return INSTANCE;
    }

    private static <Q extends Quantity<Q>> Unit<Q> addUnit(Class<Q> type, Unit<Q> unit, String symbol, boolean baseUnit) {
        List units = Units.INSTANCE.quantityToUnits.computeIfAbsent(type, t -> new ArrayList());
        units.add(unit);
        if (baseUnit) {
            Units.INSTANCE.quantityToUnit.put(type, unit);
        }
        if (symbol == null) {
            return AbstractSystemOfUnits.Helper.addUnit((Set)Units.INSTANCE.units, unit, (String)unit.toString());
        }
        return AbstractSystemOfUnits.Helper.addUnit((Set)Units.INSTANCE.units, unit, (String)symbol, (String)symbol, (UnitStyle)UnitStyle.SYMBOL_AND_LABEL);
    }

    private Units() {
    }

    public String getName() {
        return Units.class.getSimpleName();
    }

    public <Q extends Quantity<Q>> List<Unit<Q>> getUnits(Class<Q> type) {
        List<Unit<Q>> units = Collections.unmodifiableList(Optional.ofNullable(this.quantityToUnits.get(type)).orElse(Collections.emptyList()));
        return units;
    }
}

