/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx;

import com.dlsc.unitfx.util.QuantitiesUtil;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.util.StringConverter;
import javax.measure.Quantity;
import javax.measure.Unit;

public abstract class QuantityInputControl<Q extends Quantity<Q>>
extends Control {
    private final ObjectProperty<Double> value = new SimpleObjectProperty((Object)this, "value");
    private final ObjectProperty<Unit<Q>> unit = new SimpleObjectProperty((Object)this, "unit");
    private final ReadOnlyObjectWrapper<Quantity<Q>> valueQuantity = new ReadOnlyObjectWrapper((Object)this, "quantityValue");
    private final ObservableList<Unit<Q>> availableUnits = FXCollections.observableArrayList();
    private final ObjectProperty<Unit<Q>> baseUnit = new SimpleObjectProperty((Object)this, "baseUnit");
    private final BooleanProperty readOnly = new SimpleBooleanProperty((Object)this, "readOnly");
    private final ObjectProperty<StringConverter<Unit<Q>>> unitStringConverter = new SimpleObjectProperty((Object)this, "unitStringConverter");
    private final IntegerProperty numberOfIntegers = new SimpleIntegerProperty((Object)this, "numberOfIntegers", 40);
    private final IntegerProperty numberOfDecimals = new SimpleIntegerProperty((Object)this, "numberOfDecimals", 3);

    public QuantityInputControl() {
        this.bindQuantityValueProperty();
        this.listenForDefaultUnit();
    }

    public final ObjectProperty<Double> valueProperty() {
        return this.value;
    }

    public final Double getValue() {
        return (Double)this.valueProperty().get();
    }

    public final void setValue(Double value) {
        this.valueProperty().set((Object)value);
    }

    public final ObjectProperty<Unit<Q>> unitProperty() {
        return this.unit;
    }

    public final Unit<Q> getUnit() {
        return (Unit)this.unitProperty().get();
    }

    public final void setUnit(Unit<Q> unit) {
        this.unitProperty().set(unit);
    }

    public final ReadOnlyObjectProperty<Quantity<Q>> valueQuantityProperty() {
        return this.valueQuantity.getReadOnlyProperty();
    }

    public final Quantity<Q> getValueQuantity() {
        return (Quantity)this.valueQuantityProperty().get();
    }

    void setValueQuantity(Quantity<Q> valueQuantity) {
        this.valueQuantity.set(valueQuantity);
    }

    public final ObservableList<Unit<Q>> getAvailableUnits() {
        return this.availableUnits;
    }

    public final ObjectProperty<Unit<Q>> baseUnitProperty() {
        return this.baseUnit;
    }

    public final Unit<Q> getBaseUnit() {
        return (Unit)this.baseUnitProperty().get();
    }

    public final void setBaseUnit(Unit<Q> baseUnit) {
        this.baseUnitProperty().set(baseUnit);
    }

    public final BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    public final boolean isReadOnly() {
        return this.readOnlyProperty().get();
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnlyProperty().set(readOnly);
    }

    public final ObjectProperty<StringConverter<Unit<Q>>> unitStringConverterProperty() {
        return this.unitStringConverter;
    }

    public final StringConverter<Unit<Q>> getUnitStringConverter() {
        return (StringConverter)this.unitStringConverterProperty().get();
    }

    public final void setUnitStringConverter(StringConverter<Unit<Q>> unitStringConverter) {
        this.unitStringConverterProperty().set(unitStringConverter);
    }

    public final IntegerProperty numberOfIntegersProperty() {
        return this.numberOfIntegers;
    }

    public final int getNumberOfIntegers() {
        return this.numberOfIntegersProperty().get();
    }

    public final void setNumberOfIntegers(int numberOfIntegers) {
        this.numberOfIntegersProperty().set(numberOfIntegers);
    }

    public final IntegerProperty numberOfDecimalsProperty() {
        return this.numberOfDecimals;
    }

    public final int getNumberOfDecimals() {
        return this.numberOfDecimalsProperty().get();
    }

    public final void setNumberOfDecimals(int numberOfDecimals) {
        this.numberOfDecimalsProperty().set(numberOfDecimals);
    }

    private void bindQuantityValueProperty() {
        InvalidationListener listener = obs -> this.updateValueQuantity();
        this.valueProperty().addListener(listener);
        this.unitProperty().addListener(listener);
    }

    private void listenForDefaultUnit() {
        this.baseUnitProperty().addListener((obs, oldV, newV) -> this.updateDefaultUnit((Unit<Q>)newV));
    }

    void updateValueQuantity() {
        Quantity<Q> quantity = QuantitiesUtil.createQuantity(this.getValue(), this.getUnit());
        this.setValueQuantity(quantity);
    }

    void updateDefaultUnit(Unit<Q> baseUnit) {
        if (this.getUnit() == null) {
            this.setUnit(baseUnit);
        }
    }
}

