/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl;

public enum CSLLabel {
    BOOK("book"),
    CHAPTER("chapter"),
    COLUMN("column"),
    FIGURE("figure"),
    FOLIO("folio"),
    ISSUE("issue"),
    LINE("line"),
    NOTE("note"),
    OPUS("opus"),
    PAGE("page"),
    PARAGRAPH("paragraph"),
    PART("part"),
    SECTION("section"),
    SUB_VERBO("sub-verbo"),
    VERSE("verse"),
    VOLUME("volume");

    private final String name;

    private CSLLabel(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static CSLLabel fromString(String str) {
        if (str.equals("book")) {
            return BOOK;
        }
        if (str.equals("chapter")) {
            return CHAPTER;
        }
        if (str.equals("column")) {
            return COLUMN;
        }
        if (str.equals("figure")) {
            return FIGURE;
        }
        if (str.equals("folio")) {
            return FOLIO;
        }
        if (str.equals("issue")) {
            return ISSUE;
        }
        if (str.equals("line")) {
            return LINE;
        }
        if (str.equals("note")) {
            return NOTE;
        }
        if (str.equals("opus")) {
            return OPUS;
        }
        if (str.equals("page")) {
            return PAGE;
        }
        if (str.equals("paragraph")) {
            return PARAGRAPH;
        }
        if (str.equals("part")) {
            return PART;
        }
        if (str.equals("section")) {
            return SECTION;
        }
        if (str.equals("sub-verbo") || str.equals("sub verbo")) {
            return SUB_VERBO;
        }
        if (str.equals("verse")) {
            return VERSE;
        }
        if (str.equals("volume")) {
            return VOLUME;
        }
        throw new IllegalArgumentException("Unknown CSLLabel: " + str);
    }
}

