/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.EnumSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.search.rules.FullTextSearchRule;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="Because access to the lucene index is needed")
public class RegexBasedSearchRule
extends FullTextSearchRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexBasedSearchRule.class);

    public RegexBasedSearchRule(EnumSet<SearchRules.SearchFlags> searchFlags) {
        super(searchFlags);
    }

    @Override
    public boolean validateSearchStrings(String query) {
        try {
            Pattern.compile(query, this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE) ? 0 : 2);
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean applyRule(String query, BibEntry bibEntry) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(StringUtil.stripAccents(query), this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE) ? 0 : 2);
        }
        catch (PatternSyntaxException ex) {
            LOGGER.debug("Could not compile regex {}", (Object)query, (Object)ex);
            return false;
        }
        for (Field field : bibEntry.getFields()) {
            String fieldContentNoBrackets;
            Matcher m;
            Optional<String> fieldOptional = bibEntry.getField(field);
            if (!fieldOptional.isPresent() || !(m = pattern.matcher(fieldContentNoBrackets = StringUtil.stripAccents(bibEntry.getFieldLatexFree(field).get()))).find()) continue;
            return true;
        }
        return this.getFulltextResults(query, bibEntry).numSearchResults() > 0;
    }
}

