/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search;

import java.util.EnumSet;
import java.util.Objects;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.search.rules.SearchRule;
import org.jabref.model.search.rules.SearchRules;

public class GroupSearchQuery
implements SearchMatcher {
    private final String query;
    private final EnumSet<SearchRules.SearchFlags> searchFlags;
    private final SearchRule rule;

    public GroupSearchQuery(String query, EnumSet<SearchRules.SearchFlags> searchFlags) {
        this.query = Objects.requireNonNull(query);
        this.searchFlags = searchFlags;
        this.rule = Objects.requireNonNull(this.getSearchRule());
    }

    public String toString() {
        return "\"%s\" (%s, %s)".formatted(this.query, this.getCaseSensitiveDescription(), this.getRegularExpressionDescription());
    }

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.getRule().applyRule(this.query, entry);
    }

    private SearchRule getSearchRule() {
        return SearchRules.getSearchRuleByQuery(this.query, this.searchFlags);
    }

    private String getCaseSensitiveDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
            return "case sensitive";
        }
        return "case insensitive";
    }

    private String getRegularExpressionDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION)) {
            return "regular expression";
        }
        return "plain text";
    }

    public SearchRule getRule() {
        return this.rule;
    }

    public String getSearchExpression() {
        return this.query;
    }

    public EnumSet<SearchRules.SearchFlags> getSearchFlags() {
        return this.searchFlags;
    }
}

