/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextDocument;
import java.util.Optional;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoProperties;
import org.jabref.model.openoffice.uno.UnoReferenceMark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnoTextDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnoTextDocument.class);

    private UnoTextDocument() {
    }

    public static boolean isDocumentConnectionMissing(XTextDocument doc) {
        boolean missing;
        boolean bl = missing = doc == null;
        if (!missing) {
            try {
                UnoReferenceMark.getNameAccess(doc);
            }
            catch (DisposedException | NoDocumentException ex) {
                missing = true;
            }
        }
        return missing;
    }

    public static Optional<XController> getCurrentController(XTextDocument doc) {
        if (doc == null) {
            return Optional.empty();
        }
        XController controller = doc.getCurrentController();
        if (controller == null) {
            LOGGER.warn("doc.getCurrentController() returned null");
            return Optional.empty();
        }
        return Optional.of(controller);
    }

    public static Optional<String> getFrameTitle(XTextDocument doc) {
        Optional<XFrame> frame = UnoTextDocument.getCurrentController(doc).map(XController::getFrame);
        if (frame.isEmpty()) {
            return Optional.empty();
        }
        Optional<XPropertySet> propertySet = UnoCast.cast(XPropertySet.class, frame.get());
        if (propertySet.isEmpty()) {
            return Optional.empty();
        }
        try {
            Optional<Object> frameTitleObj = UnoProperties.getValueAsObject(propertySet.get(), "Title");
            if (frameTitleObj.isEmpty()) {
                return Optional.empty();
            }
            String frameTitleString = String.valueOf(frameTitleObj.get());
            return Optional.ofNullable(frameTitleString);
        }
        catch (WrappedTargetException e) {
            LOGGER.warn("Could not get document title", (Throwable)e);
            return Optional.empty();
        }
    }

    static Optional<XDocumentProperties> getDocumentProperties(XTextDocument doc) {
        return Optional.ofNullable(doc).flatMap(e -> UnoCast.cast(XDocumentPropertiesSupplier.class, e)).map(XDocumentPropertiesSupplier::getDocumentProperties);
    }
}

