/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.Optional;
import org.jabref.model.openoffice.DocumentAnnotation;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoNameAccess;
import org.jabref.model.openoffice.uno.UnoNamed;

public class UnoBookmark {
    private UnoBookmark() {
    }

    public static XNameAccess getNameAccess(XTextDocument doc) throws NoDocumentException {
        XBookmarksSupplier supplier = UnoCast.cast(XBookmarksSupplier.class, doc).get();
        try {
            return supplier.getBookmarks();
        }
        catch (DisposedException ex) {
            throw new NoDocumentException("UnoBookmark.getNameAccess failed with" + String.valueOf((Object)ex));
        }
    }

    public static Optional<XTextRange> getAnchor(XTextDocument doc, String name) throws WrappedTargetException, NoDocumentException {
        XNameAccess nameAccess = UnoBookmark.getNameAccess(doc);
        return UnoNameAccess.getTextContentByName(nameAccess, name).map(XTextContent::getAnchor);
    }

    public static XNamed create(DocumentAnnotation documentAnnotation) throws CreationException {
        return UnoNamed.insertNamedTextContent("com.sun.star.text.Bookmark", documentAnnotation);
    }

    public static void removeIfExists(XTextDocument doc, String name) throws NoDocumentException, WrappedTargetException {
        XNameAccess marks = UnoBookmark.getNameAccess(doc);
        if (marks.hasByName(name)) {
            Optional<XTextContent> mark = UnoNameAccess.getTextContentByName(marks, name);
            if (mark.isEmpty()) {
                return;
            }
            try {
                doc.getText().removeTextContent(mark.get());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }
}

