/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.style;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroupId;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.style.CompareCitation;
import org.jabref.model.openoffice.style.OODataModel;
import org.jabref.model.openoffice.util.OOListUtil;

public class CitationGroup {
    public final OODataModel dataModel;
    public final CitationGroupId groupId;
    public final CitationType citationType;
    public final List<Citation> citationsInStorageOrder;
    private Optional<String> referenceMarkNameForLinking;
    private List<Integer> localOrder;
    private Optional<Integer> indexInGlobalOrder;
    private Optional<OOText> citationMarker;

    public CitationGroup(OODataModel dataModel, CitationGroupId groupId, CitationType citationType, List<Citation> citationsInStorageOrder, Optional<String> referenceMarkNameForLinking) {
        this.dataModel = dataModel;
        this.groupId = groupId;
        this.citationType = citationType;
        this.citationsInStorageOrder = Collections.unmodifiableList(citationsInStorageOrder);
        this.localOrder = OOListUtil.makeIndices(citationsInStorageOrder.size());
        this.referenceMarkNameForLinking = referenceMarkNameForLinking;
        this.indexInGlobalOrder = Optional.empty();
        this.citationMarker = Optional.empty();
    }

    public int numberOfCitations() {
        return this.citationsInStorageOrder.size();
    }

    void imposeLocalOrder(Comparator<BibEntry> entryComparator) {
        int last = this.numberOfCitations() - 1;
        Optional<OOText> lastPageInfo = Optional.empty();
        if (this.dataModel == OODataModel.JabRef52) {
            Citation lastCitation = this.getCitationsInLocalOrder().get(last);
            lastPageInfo = lastCitation.getPageInfo();
            lastCitation.setPageInfo(Optional.empty());
        }
        this.localOrder = OOListUtil.order(this.citationsInStorageOrder, new CompareCitation(entryComparator, true));
        if (this.dataModel == OODataModel.JabRef52) {
            this.getCitationsInLocalOrder().get(last).setPageInfo(lastPageInfo);
        }
    }

    public List<Integer> getLocalOrder() {
        return Collections.unmodifiableList(this.localOrder);
    }

    public List<Citation> getCitationsInLocalOrder() {
        return OOListUtil.map(this.localOrder, this.citationsInStorageOrder::get);
    }

    public void setIndexInGlobalOrder(Optional<Integer> indexInGlobalOrder) {
        this.indexInGlobalOrder = indexInGlobalOrder;
    }

    public Optional<Integer> getIndexInGlobalOrder() {
        return this.indexInGlobalOrder;
    }

    public Optional<String> getReferenceMarkNameForLinking() {
        return this.referenceMarkNameForLinking;
    }

    public void setReferenceMarkNameForLinking(Optional<String> referenceMarkNameForLinking) {
        this.referenceMarkNameForLinking = referenceMarkNameForLinking;
    }

    public void setCitationMarker(Optional<OOText> citationMarker) {
        this.citationMarker = citationMarker;
    }

    public Optional<OOText> getCitationMarker() {
        return this.citationMarker;
    }
}

