/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.model.FieldChange;
import org.jabref.model.TreeNode;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.search.matchers.MatcherSet;
import org.jabref.model.search.matchers.MatcherSets;

public class GroupTreeNode
extends TreeNode<GroupTreeNode> {
    private static final String PATH_DELIMITER = " > ";
    private AbstractGroup group;

    public GroupTreeNode(AbstractGroup group) {
        super(GroupTreeNode.class);
        this.setGroup(group, false, false, null);
    }

    public static GroupTreeNode fromGroup(AbstractGroup group) {
        return new GroupTreeNode(group);
    }

    public AbstractGroup getGroup() {
        return this.group;
    }

    @Deprecated
    public void setGroup(AbstractGroup newGroup) {
        this.group = Objects.requireNonNull(newGroup);
    }

    public List<FieldChange> setGroup(AbstractGroup newGroup, boolean shouldKeepPreviousAssignments, boolean shouldRemovePreviousAssignments, List<BibEntry> entriesInDatabase) {
        ArrayList<FieldChange> changes;
        block6: {
            GroupEntryChanger entryChanger;
            boolean shouldAddToNewGroup;
            boolean shouldRemoveFromOldGroup;
            AbstractGroup oldGroup;
            block5: {
                oldGroup = this.getGroup();
                this.group = Objects.requireNonNull(newGroup);
                changes = new ArrayList<FieldChange>();
                shouldRemoveFromOldGroup = shouldRemovePreviousAssignments && oldGroup instanceof GroupEntryChanger;
                boolean bl = shouldAddToNewGroup = shouldKeepPreviousAssignments && newGroup instanceof GroupEntryChanger;
                if (shouldAddToNewGroup) break block5;
                if (!shouldRemoveFromOldGroup) break block6;
            }
            List<BibEntry> entriesMatchedByOldGroup = entriesInDatabase.stream().filter(oldGroup::isMatch).collect(Collectors.toList());
            if (shouldRemoveFromOldGroup) {
                entryChanger = (GroupEntryChanger)((Object)oldGroup);
                changes.addAll(entryChanger.remove(entriesMatchedByOldGroup));
            }
            if (shouldAddToNewGroup) {
                entryChanger = (GroupEntryChanger)((Object)newGroup);
                changes.addAll(entryChanger.add(entriesMatchedByOldGroup));
            }
        }
        return changes;
    }

    public SearchMatcher getSearchMatcher() {
        return this.getSearchMatcher(this.group.getHierarchicalContext());
    }

    private SearchMatcher getSearchMatcher(GroupHierarchyType originalContext) {
        GroupHierarchyType context = this.group.getHierarchicalContext();
        if (context == GroupHierarchyType.INDEPENDENT) {
            return this.group;
        }
        MatcherSet searchRule = MatcherSets.build(context == GroupHierarchyType.REFINING ? MatcherSets.MatcherType.AND : MatcherSets.MatcherType.OR);
        searchRule.addRule(this.group);
        if (context == GroupHierarchyType.INCLUDING && originalContext != GroupHierarchyType.REFINING) {
            for (GroupTreeNode child : this.getChildren()) {
                searchRule.addRule(child.getSearchMatcher(originalContext));
            }
        } else if (context == GroupHierarchyType.REFINING && !this.isRoot() && originalContext != GroupHierarchyType.INCLUDING) {
            searchRule.addRule(((GroupTreeNode)this.getParent().get()).getSearchMatcher(originalContext));
        }
        return searchRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupTreeNode that = (GroupTreeNode)o;
        return Objects.equals(this.group, that.group) && Objects.equals(this.getChildren(), that.getChildren());
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }

    public List<GroupTreeNode> getContainingGroups(List<BibEntry> entries, boolean requireAll) {
        ArrayList<GroupTreeNode> groups = new ArrayList<GroupTreeNode>();
        if (requireAll) {
            if (this.group.containsAll(entries)) {
                groups.add(this);
            }
        } else if (this.group.containsAny(entries)) {
            groups.add(this);
        }
        for (GroupTreeNode child : this.getChildren()) {
            groups.addAll(child.getContainingGroups(entries, requireAll));
        }
        return groups;
    }

    public List<GroupTreeNode> getMatchingGroups(BibEntry entry) {
        return this.getMatchingGroups(Collections.singletonList(entry));
    }

    public List<GroupTreeNode> getMatchingGroups(List<BibEntry> entries) {
        ArrayList<GroupTreeNode> groups = new ArrayList<GroupTreeNode>();
        SearchMatcher matcher = this.getSearchMatcher();
        for (BibEntry entry : entries) {
            if (!matcher.isMatch(entry)) continue;
            groups.add(this);
            break;
        }
        for (GroupTreeNode child : this.getChildren()) {
            groups.addAll(child.getMatchingGroups(entries));
        }
        return groups;
    }

    public List<BibEntry> getEntriesInGroup(List<BibEntry> entries) {
        ArrayList<BibEntry> result = new ArrayList<BibEntry>();
        for (BibEntry entry : entries) {
            if (!this.group.contains(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public String getName() {
        return this.group.getName();
    }

    public GroupTreeNode addSubgroup(AbstractGroup subgroup) {
        GroupTreeNode child = GroupTreeNode.fromGroup(subgroup);
        this.addChild(child);
        return child;
    }

    @Override
    public GroupTreeNode copyNode() {
        return GroupTreeNode.fromGroup(this.group);
    }

    public List<BibEntry> findMatches(List<BibEntry> entries) {
        SearchMatcher matcher = this.getSearchMatcher();
        return entries.stream().filter(matcher::isMatch).collect(Collectors.toList());
    }

    public List<BibEntry> findMatches(BibDatabase database) {
        return this.findMatches((List<BibEntry>)database.getEntries());
    }

    public boolean matches(BibEntry entry) {
        return this.getSearchMatcher().isMatch(entry);
    }

    public String getPath() {
        return this.getPathFromRoot().stream().skip(1L).map(GroupTreeNode::getName).collect(Collectors.joining(PATH_DELIMITER));
    }

    public String toString() {
        return "GroupTreeNode{group=" + String.valueOf(this.group) + "}";
    }

    public Optional<GroupTreeNode> getChildByPath(String pathToSource) {
        GroupTreeNode present = this;
        for (String groupName : pathToSource.split(PATH_DELIMITER)) {
            Optional<GroupTreeNode> childWithName = present.getChildren().stream().filter(group -> Objects.equals(group.getName(), groupName)).findFirst();
            if (!childWithName.isPresent()) {
                return Optional.empty();
            }
            present = childWithName.get();
        }
        return Optional.of(present);
    }

    public List<FieldChange> addEntriesToGroup(Collection<BibEntry> entries) {
        if (this.getGroup() instanceof GroupEntryChanger) {
            return ((GroupEntryChanger)((Object)this.getGroup())).add(entries);
        }
        return Collections.emptyList();
    }

    public List<FieldChange> removeEntriesFromGroup(List<BibEntry> entries) {
        if (this.getGroup() instanceof GroupEntryChanger) {
            return ((GroupEntryChanger)((Object)this.getGroup())).remove(entries);
        }
        return Collections.emptyList();
    }

    public boolean isSameGroupAs(GroupTreeNode other) {
        return Objects.equals(this.group, other.group);
    }
}

