/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.identifier;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.Identifier;

public class ISBN
implements Identifier {
    private static final Pattern ISBN_PATTERN = Pattern.compile("^(\\d{9}[\\dxX]|\\d{13})$");
    private final String isbnString;

    public ISBN(String isbnString) {
        this.isbnString = Objects.requireNonNull(isbnString).trim().replace("-", "");
    }

    public static Optional<ISBN> parse(String input) {
        ISBN isbn = new ISBN(input);
        if (isbn.isValid()) {
            return Optional.of(isbn);
        }
        return Optional.empty();
    }

    public boolean isValidFormat() {
        Matcher isbnMatcher = ISBN_PATTERN.matcher(this.isbnString);
        return isbnMatcher.matches();
    }

    public boolean isValidChecksum() {
        boolean valid = this.isbnString.length() == 10 ? this.isbn10check() : this.isbn13check();
        return valid;
    }

    public boolean isIsbn10() {
        return this.isbn10check();
    }

    public boolean isIsbn13() {
        return this.isbn13check();
    }

    private boolean isbn10check() {
        if (this.isbnString.length() != 10) {
            return false;
        }
        int sum = 0;
        for (int pos = 0; pos <= 8; ++pos) {
            sum += (this.isbnString.charAt(pos) - 48) * (10 - pos);
        }
        int control = this.isbnString.charAt(9);
        if (control == 120 || control == 88) {
            control = 58;
        }
        return (sum += control - 48) % 11 == 0;
    }

    private boolean isbn13check() {
        if (this.isbnString.length() != 13) {
            return false;
        }
        int sum = 0;
        for (int pos = 0; pos <= 12; ++pos) {
            sum += (this.isbnString.charAt(pos) - 48) * (pos % 2 == 0 ? 1 : 3);
        }
        return sum % 10 == 0;
    }

    public boolean isValid() {
        return this.isValidFormat() && this.isValidChecksum();
    }

    @Override
    public Field getDefaultField() {
        return StandardField.ISBN;
    }

    @Override
    public String getNormalized() {
        return this.isbnString;
    }

    @Override
    public Optional<URI> getExternalURI() {
        try {
            return Optional.of(new URI("https://www.worldcat.org/isbn/" + this.isbnString));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISBN other = (ISBN)o;
        return this.isbnString.equalsIgnoreCase(other.isbnString);
    }

    public int hashCode() {
        return Objects.hash(this.isbnString.toLowerCase(Locale.ENGLISH));
    }
}

