/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.field;

import java.util.EnumSet;
import java.util.Optional;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.strings.StringUtil;

public interface Field {
    public EnumSet<FieldProperty> getProperties();

    default public String getDisplayName() {
        return StringUtil.capitalizeFirst(this.getName());
    }

    public String getName();

    public boolean isStandardField();

    default public boolean isDeprecated() {
        return false;
    }

    default public Optional<Field> getAlias() {
        return Optional.empty();
    }

    default public boolean isNumeric() {
        return this.getProperties().contains((Object)FieldProperty.NUMERIC);
    }

    default public boolean isMultiLineDefined() {
        return this.getProperties().contains((Object)FieldProperty.MULTILINE_TEXT);
    }
}

