/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;

public class CanonicalBibEntry {
    private CanonicalBibEntry() {
    }

    public static String getCanonicalRepresentation(BibEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(entry.getUserComments());
        String citeKey = entry.getCitationKey().orElse("");
        sb.append("@%s{%s,".formatted(entry.getType().getName(), citeKey)).append('\n');
        HashMap<String, String> mapFieldToValue = new HashMap<String, String>();
        TreeSet<String> sortedFields = new TreeSet<String>();
        for (Map.Entry<Field, String> field : entry.getFieldMap().entrySet()) {
            Field field2 = field.getKey();
            String fieldValue = field.getValue();
            if (field2.equals(InternalField.KEY_FIELD)) continue;
            String lowerCaseFieldName = field2.getName().toLowerCase(Locale.US);
            sortedFields.add(lowerCaseFieldName);
            mapFieldToValue.put(lowerCaseFieldName, fieldValue);
        }
        StringJoiner sj = new StringJoiner(",\n", "", "\n");
        for (String string : sortedFields) {
            String line = "  %s = {%s}".formatted(string, mapFieldToValue.get(string));
            sj.add(line);
        }
        sj.add("  _jabref_shared = {sharedId: %d, version: %d}".formatted(entry.getSharedBibEntryData().getSharedID(), entry.getSharedBibEntryData().getVersion()));
        sb.append(sj);
        sb.append('}');
        return sb.toString();
    }
}

