/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Objects;
import java.util.Optional;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.logic.formatter.bibtexfields.RemoveWordEnclosingAndOuterEnclosingBracesFormatter;
import org.jabref.model.strings.LatexToUnicodeAdapter;
import org.jabref.model.strings.StringUtil;

@AllowedToUseLogic(value="because it needs to use formatter")
public class Author {
    public static final Author OTHERS = new Author("", "", null, "others", null);
    public static final RemoveWordEnclosingAndOuterEnclosingBracesFormatter FORMATTER = new RemoveWordEnclosingAndOuterEnclosingBracesFormatter();
    private final String givenName;
    private final String givenNameAbbreviated;
    private final String namePrefix;
    private final String familyName;
    private final String nameSuffix;
    private Author latexFreeAuthor;

    public Author(String givenName, String givenNameAbbreviated, String namePrefix, String familyName, String nameSuffix) {
        boolean keepBracesAtLastPart = StringUtil.isBlank(givenName) && StringUtil.isBlank(givenNameAbbreviated) && StringUtil.isBlank(namePrefix) && !StringUtil.isBlank(familyName) && StringUtil.isBlank(nameSuffix);
        this.givenName = !StringUtil.isBlank(givenName) ? Author.addDotIfAbbreviation(FORMATTER.format(givenName)) : null;
        this.givenNameAbbreviated = !StringUtil.isBlank(givenNameAbbreviated) ? FORMATTER.format(givenNameAbbreviated) : null;
        this.namePrefix = !StringUtil.isBlank(namePrefix) ? FORMATTER.format(namePrefix) : null;
        this.familyName = keepBracesAtLastPart ? familyName : (!StringUtil.isBlank(familyName) ? FORMATTER.format(familyName) : null);
        this.nameSuffix = !StringUtil.isBlank(nameSuffix) ? FORMATTER.format(nameSuffix) : null;
    }

    public static String addDotIfAbbreviation(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.length() == 1 && Character.isLetter(name.charAt(0)) && Character.isUpperCase(name.charAt(0))) {
            return name + ".";
        }
        StringBuilder sb = new StringBuilder();
        char lastChar = name.charAt(0);
        for (int i = 0; i < name.length(); ++i) {
            boolean lastIsLowercaseLetter;
            boolean currentIsUppercaseLetter;
            if (i > 0) {
                lastChar = name.charAt(i - 1);
            }
            char currentChar = name.charAt(i);
            sb.append(currentChar);
            if (currentChar == '.' && i + 1 < name.length() && Character.isUpperCase(name.charAt(i + 1))) {
                sb.append(' ');
            }
            boolean bl = currentIsUppercaseLetter = Character.isLetter(currentChar) && Character.isUpperCase(currentChar);
            if (!currentIsUppercaseLetter) continue;
            boolean bl2 = lastIsLowercaseLetter = Character.isLetter(lastChar) && Character.isLowerCase(lastChar);
            if (lastIsLowercaseLetter) continue;
            if (i + 1 >= name.length()) {
                sb.append('.');
                continue;
            }
            char nextChar = name.charAt(i + 1);
            if ('-' == nextChar) {
                sb.append(".");
                continue;
            }
            if ('.' == nextChar) continue;
            boolean nextWordIsUppercase = true;
            char furtherChar = '\u0000';
            for (int j = i + 1; j < name.length() && !Character.isWhitespace(furtherChar = name.charAt(j)) && furtherChar != '-' && furtherChar != '~' && furtherChar != '.'; ++j) {
                boolean furtherIsUppercaseLetter;
                boolean bl3 = furtherIsUppercaseLetter = Character.isLetter(furtherChar) && Character.isUpperCase(furtherChar);
                if (furtherIsUppercaseLetter) continue;
                nextWordIsUppercase = false;
                break;
            }
            if (!nextWordIsUppercase) continue;
            if (Character.isWhitespace(furtherChar)) {
                sb.append(".");
                continue;
            }
            sb.append(". ");
        }
        return sb.toString().trim();
    }

    public int hashCode() {
        return Objects.hash(this.givenNameAbbreviated, this.givenName, this.nameSuffix, this.familyName, this.namePrefix);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Author) {
            Author that = (Author)other;
            return Objects.equals(this.givenName, that.givenName) && Objects.equals(this.givenNameAbbreviated, that.givenNameAbbreviated) && Objects.equals(this.namePrefix, that.namePrefix) && Objects.equals(this.familyName, that.familyName) && Objects.equals(this.nameSuffix, that.nameSuffix);
        }
        return false;
    }

    public Optional<String> getGivenName() {
        return Optional.ofNullable(this.givenName);
    }

    public Optional<String> getGivenNameAbbreviated() {
        return Optional.ofNullable(this.givenNameAbbreviated);
    }

    public Optional<String> getNamePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    public Optional<String> getFamilyName() {
        return Optional.ofNullable(this.familyName);
    }

    public Optional<String> getNameSuffix() {
        return Optional.ofNullable(this.nameSuffix);
    }

    public String getNamePrefixAndFamilyName() {
        if (this.namePrefix == null || "".equals(this.namePrefix)) {
            return this.getFamilyName().orElse("");
        }
        return this.familyName == null ? this.namePrefix : this.namePrefix + " " + this.familyName;
    }

    public String getFamilyGiven(boolean abbr) {
        StringBuilder res = new StringBuilder(this.getNamePrefixAndFamilyName());
        this.getNameSuffix().ifPresent(jr -> res.append(", ").append((String)jr));
        if (abbr) {
            this.getGivenNameAbbreviated().ifPresent(firstA -> res.append(", ").append((String)firstA));
        } else {
            this.getGivenName().ifPresent(first -> res.append(", ").append((String)first));
        }
        return res.toString();
    }

    public String getGivenFamily(boolean abbr) {
        StringBuilder res = new StringBuilder();
        if (abbr) {
            this.getGivenNameAbbreviated().map(firstA -> firstA + " ").ifPresent(res::append);
        } else {
            this.getGivenName().map(first -> first + " ").ifPresent(res::append);
        }
        res.append(this.getNamePrefixAndFamilyName());
        this.getNameSuffix().ifPresent(jr -> res.append(", ").append((String)jr));
        return res.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Author{");
        sb.append("givenName='").append(this.givenName).append('\'');
        sb.append(", givenNameAbbreviated='").append(this.givenNameAbbreviated).append('\'');
        sb.append(", namePrefix='").append(this.namePrefix).append('\'');
        sb.append(", familyName='").append(this.familyName).append('\'');
        sb.append(", nameSuffix='").append(this.nameSuffix).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getNameForAlphabetization() {
        StringBuilder res = new StringBuilder();
        this.getFamilyName().ifPresent(res::append);
        this.getNameSuffix().ifPresent(jr -> res.append(", ").append((String)jr));
        this.getGivenNameAbbreviated().ifPresent(firstA -> res.append(", ").append((String)firstA));
        while (res.length() > 0 && res.charAt(0) == '{') {
            res.deleteCharAt(0);
        }
        return res.toString();
    }

    public Author latexFree() {
        if (this.latexFreeAuthor == null) {
            String first = this.getGivenName().map(LatexToUnicodeAdapter::format).orElse(null);
            String givenNameAbbreviated = this.getGivenNameAbbreviated().map(LatexToUnicodeAdapter::format).orElse(null);
            String von = this.getNamePrefix().map(LatexToUnicodeAdapter::format).orElse(null);
            String last = this.getFamilyName().map(LatexToUnicodeAdapter::format).orElse(null);
            String jr = this.getNameSuffix().map(LatexToUnicodeAdapter::format).orElse(null);
            this.latexFreeAuthor.latexFreeAuthor = this.latexFreeAuthor = new Author(first, givenNameAbbreviated, von, last, jr);
        }
        return this.latexFreeAuthor;
    }
}

