/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.database;

import java.util.stream.Stream;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;

public class BibDatabaseModeDetection {
    private BibDatabaseModeDetection() {
    }

    public static BibDatabaseMode inferMode(BibDatabase database) {
        Stream<EntryType> entryTypes = database.getEntries().stream().map(BibEntry::getType);
        if (entryTypes.anyMatch(EntryTypeFactory::isExclusiveBiblatex)) {
            return BibDatabaseMode.BIBLATEX;
        }
        return BibDatabaseMode.BIBTEX;
    }
}

