/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HexFormat;
import java.util.Optional;
import org.jabref.logic.util.BackupFileType;
import org.jabref.logic.util.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupFileUtil.class);

    private BackupFileUtil() {
    }

    public static Path getPathForNewBackupFileAndCreateDirectory(Path targetFile, BackupFileType fileType, Path backupDir) {
        String extension = "." + fileType.getExtensions().getFirst();
        String timeSuffix = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd--HH.mm.ss"));
        Path directory = backupDir;
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            Path result = FileUtil.addExtension(targetFile, extension);
            LOGGER.warn("Could not create bib writing directory {}, using {} as file", new Object[]{directory, result, e});
            return result;
        }
        String baseFileName = BackupFileUtil.getUniqueFilePrefix(targetFile) + "--" + String.valueOf(targetFile.getFileName()) + "--" + timeSuffix;
        Path fileName = FileUtil.addExtension(Path.of(baseFileName, new String[0]), extension);
        return directory.resolve(fileName);
    }

    public static Optional<Path> getPathOfLatestExistingBackupFile(Path targetFile, BackupFileType fileType, Path backupDir) {
        Optional<Path> mostRecentFile;
        String extension = "." + fileType.getExtensions().getFirst();
        if (Files.notExists(backupDir, new LinkOption[0])) {
            Path result = FileUtil.addExtension(targetFile, extension);
            if (Files.exists(result, new LinkOption[0])) {
                return Optional.of(result);
            }
            return Optional.empty();
        }
        String prefix = BackupFileUtil.getUniqueFilePrefix(targetFile) + "--" + String.valueOf(targetFile.getFileName());
        try {
            mostRecentFile = Files.list(backupDir).filter(p -> p.getFileName().toString().startsWith(prefix)).sorted().reduce((first, second) -> second);
        }
        catch (IOException e) {
            LOGGER.error("Could not determine most recent file", (Throwable)e);
            return Optional.empty();
        }
        return mostRecentFile;
    }

    public static String getUniqueFilePrefix(Path targetFile) {
        int positiveCode = Math.abs(targetFile.hashCode());
        byte[] array = ByteBuffer.allocate(4).putInt(positiveCode).array();
        return HexFormat.of().formatHex(array);
    }
}

