/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.remote;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javafx.util.Pair;
import org.jabref.logic.remote.RemoteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protocol
implements AutoCloseable {
    public static final String IDENTIFIER = "jabref";
    private static final Logger LOGGER = LoggerFactory.getLogger(Protocol.class);
    private final Socket socket;
    private final ObjectOutputStream out;
    private final ObjectInputStream in;

    public Protocol(Socket socket) throws IOException {
        this.socket = socket;
        this.out = new ObjectOutputStream(socket.getOutputStream());
        this.in = new ObjectInputStream(socket.getInputStream());
    }

    public void sendMessage(RemoteMessage type) throws IOException {
        this.out.writeObject((Object)type);
        this.out.writeObject(null);
        this.out.write(0);
        this.out.flush();
    }

    public void sendMessage(RemoteMessage type, Object argument) throws IOException {
        this.out.writeObject((Object)type);
        if (type == RemoteMessage.SEND_COMMAND_LINE_ARGUMENTS) {
            String[] encodedArgs = (String[])((String[])argument).clone();
            for (int i = 0; i < encodedArgs.length; ++i) {
                encodedArgs[i] = URLEncoder.encode(encodedArgs[i], StandardCharsets.UTF_8);
            }
            this.out.writeObject(encodedArgs);
        } else {
            this.out.writeObject(argument);
        }
        this.out.write(0);
        this.out.flush();
    }

    public Pair<RemoteMessage, Object> receiveMessage() throws IOException {
        try {
            RemoteMessage type = (RemoteMessage)((Object)this.in.readObject());
            Object argument = this.in.readObject();
            int endOfMessage = this.in.read();
            if (type == RemoteMessage.SEND_COMMAND_LINE_ARGUMENTS) {
                for (int i = 0; i < ((String[])argument).length; ++i) {
                    ((String[])argument)[i] = URLDecoder.decode(((String[])argument)[i], StandardCharsets.UTF_8);
                }
            }
            if (endOfMessage != 0) {
                throw new IOException("Message didn't end on correct end of message identifier. Got " + endOfMessage);
            }
            return new Pair((Object)type, argument);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not deserialize message", e);
        }
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            LOGGER.warn("Input stream not closed", (Throwable)e);
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            LOGGER.debug("Output stream not closed", (Throwable)e);
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.debug("Socket not closed", (Throwable)e);
        }
    }
}

